/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.block.BoilerBlock;
import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import chiefarug.mods.systeams.containers.BoilerMenuBase;
import cofh.lib.util.DeferredRegisterCoFH;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class Boiler<B extends BoilerBlockEntityBase, C extends BoilerMenuBase<B>>
implements ItemLike {
    private final RegistryObject<BoilerBlock> block;
    private final RegistryObject<Item> blockItem;
    private final RegistryObject<BlockEntityType<B>> blockEntity;
    private final RegistryObject<MenuType<C>> menu;
    private static final BlockBehaviour.Properties bProperties = SysteamsRegistry.B_PROPERTIES;

    public Boiler(String id, Class<B> blockEntityClass, BlockEntityType.BlockEntitySupplier<B> BEConstructor, IContainerFactory<C> containerConstructor) {
        this(id, blockEntityClass, BEConstructor, containerConstructor, SysteamsRegistry.BLOCK_REGISTRY, SysteamsRegistry.ITEM_REGISTRY, SysteamsRegistry.BLOCK_ENTITY_REGISTRY, SysteamsRegistry.MENU_REGISTRY);
    }

    public Boiler(String id, Class<B> blockEntityClass, BlockEntityType.BlockEntitySupplier<B> BEConstructor, IContainerFactory<C> containerConstructor, DeferredRegisterCoFH<Block> blockRegistry, DeferredRegisterCoFH<Item> itemRegistry, DeferredRegisterCoFH<BlockEntityType<?>> blockEntityRegistry, DeferredRegisterCoFH<MenuType<?>> menuRegistry) {
        this.block = blockRegistry.register(id, () -> new BoilerBlock(bProperties, blockEntityClass, this::blockEntity));
        this.blockItem = itemRegistry.register(id, () -> SysteamsRegistry.machineBlockItemOf((Block)this.block()));
        this.blockEntity = blockEntityRegistry.register(id, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)BEConstructor, (Block[])new Block[]{this.block()}).m_58966_(null));
        this.menu = menuRegistry.register(id, () -> IForgeMenuType.create((IContainerFactory)containerConstructor));
    }

    public BoilerBlock block() {
        return (BoilerBlock)((Object)this.block.get());
    }

    public Item item() {
        return (Item)this.blockItem.get();
    }

    public BlockEntityType<B> blockEntity() {
        return (BlockEntityType)this.blockEntity.get();
    }

    public MenuType<C> menu() {
        return (MenuType)this.menu.get();
    }

    @NotNull
    public Item m_5456_() {
        return this.item();
    }
}

