/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ContentRegistry;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.TorchBlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.PillarColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.data.BlockModelType;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.world.content.WorldCreativeTab;
import tv.soaryn.xycraft.world.content.WorldParticleContent;
import tv.soaryn.xycraft.world.content.blocks.AureyBlock;
import tv.soaryn.xycraft.world.content.blocks.ImmortalGlassBlock;
import tv.soaryn.xycraft.world.content.blocks.ImmortalStoneBlock;
import tv.soaryn.xycraft.world.content.blocks.InvertedBlock;
import tv.soaryn.xycraft.world.content.blocks.LampColoredBlock;
import tv.soaryn.xycraft.world.content.blocks.OreColoredBlock;
import tv.soaryn.xycraft.world.content.blocks.PhantomGlassViewerBlock;
import tv.soaryn.xycraft.world.content.blocks.RGBGlassBlock;
import tv.soaryn.xycraft.world.content.blocks.XyTorchBlock;
import tv.soaryn.xycraft.world.content.blocks.XyWallTorchBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampCubeBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampFlushBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampLanternBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampPillarBlock;

public interface WorldContent {
    public static final ContentRegistry Map = ContentRegistry.builder((String)"xycraft_world");
    public static final RegistryObject<CreativeModeTab> Tab = Map.tab("xycraft_world", WorldCreativeTab::new);
    public static final BlockContent Kivi = ((BlockContent)Map.block(WorldContent::kivi).withName("Kivi")).withName("fi_fi", "Stone");
    public static final BlockContent KiviRajan = ((BlockContent)Map.block(WorldContent::kivi).withModelType(BlockModelType.Connected).withName("Kivi Rajan")).withName("fi_fi", "Bordered Stone");
    public static final BlockContent SmoothKivi = ((BlockContent)Map.block(WorldContent::kivi).withModelType(BlockModelType.Connected).withName("Smooth Kivi")).withName("fi_fi", "Sile\u00e4 Stone");
    public static final BlockContent KiviBricks = ((BlockContent)Map.block(WorldContent::kivi).withName("Kivi Bricks")).withModelType(BlockModelType.Block);
    public static final EnumMap<CustomColors, BlockContent> KiviBricksCloud = Map.colorBlock(CustomColors.class, WorldContent::kivi, (color, content) -> ((BlockContent)content.withName("%s Kivi Bricks".formatted(color.name()))).withModelType(BlockModelType.Cloud));
    public static final BlockContent KiviTiles = ((BlockContent)Map.block(WorldContent::kivi).withName("Kivi Tiles")).withModelType(BlockModelType.Block);
    public static final EnumMap<CustomColors, BlockContent> KiviTilesCloud = Map.colorBlock(CustomColors.class, WorldContent::kivi, (color, content) -> ((BlockContent)content.withName("%s Kivi Tiles".formatted(color.name()))).withModelType(BlockModelType.Cloud));
    public static final EnumMap<CustomColors, BlockContent> KiviPillar = Map.colorBlock(CustomColors.class, "%s Kivi Pillar", BlockModelType.Custom, customColors -> () -> new PillarColoredBlock((ColorSource)customColors, WorldContent.KiviProperties()));
    public static final EnumMap<CustomColors, BlockContent> KiviTrim = Map.colorBlock(CustomColors.class, WorldContent::kivi, (color, content) -> ((BlockContent)content.withName("%s Kivi Trim".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> ImmortalStone = Map.colorBlock(CustomColors.class, ImmortalStoneBlock::supplier, (color, content) -> ((BlockContent)content.withName("%s Immortal Stone".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final BlockContent AluminumStorage = (BlockContent)Map.block(WorldContent::aluminum).withModelType(BlockModelType.Connected).withName("Aluminum Storage");
    public static final BlockContent AluminumBricks = ((BlockContent)Map.block(WorldContent::aluminum).withName("Aluminum Bricks")).withModelType(BlockModelType.Block);
    public static final EnumMap<CustomColors, BlockContent> AluminumBricksCloud = Map.colorBlock(CustomColors.class, WorldContent::aluminum, (color, content) -> ((BlockContent)content.withName("%s Aluminum Bricks".formatted(color.name()))).withModelType(BlockModelType.Cloud));
    public static final BlockContent AluminumTiles = ((BlockContent)Map.block(WorldContent::aluminum).withName("Aluminum Tiles")).withModelType(BlockModelType.Block);
    public static final EnumMap<CustomColors, BlockContent> AluminumTilesCloud = Map.colorBlock(CustomColors.class, WorldContent::aluminum, (color, content) -> ((BlockContent)content.withName("%s Aluminum Tiles".formatted(color.name()))).withModelType(BlockModelType.Cloud));
    public static final EnumMap<CustomColors, BlockContent> AluminumPillar = Map.colorBlock(CustomColors.class, "%s Aluminum Pillar", BlockModelType.Custom, customColors -> () -> new PillarColoredBlock((ColorSource)customColors, WorldContent.AluminumProperties()));
    public static final EnumMap<CustomColors, BlockContent> AluminumTrim = Map.colorBlock(CustomColors.class, WorldContent::aluminum, (color, content) -> ((BlockContent)content.withName("%s Aluminum Trim".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> ImmortalAluminum = Map.colorBlock(CustomColors.class, ImmortalStoneBlock::supplierAluminum, (color, content) -> ((BlockContent)content.withName("%s Immortal Aluminum".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> XychoriumStorage = Map.colorBlock(CustomColors.class, WorldContent::xychorium, (color, content) -> ((BlockContent)content.withName("%s Xychorium Gems Storage".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> InvertedBricksCloud = Map.colorBlock(CustomColors.class, InvertedBlock::supplier, (color, content) -> ((BlockContent)content.withName("%s Inverted Bricks".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> InvertedTilesCloud = Map.colorBlock(CustomColors.class, InvertedBlock::supplier, (color, content) -> ((BlockContent)content.withName("%s Inverted Tiles".formatted(color.name()))).withModelType(BlockModelType.Custom));
    public static final EnumMap<CustomColors, BlockContent> MatteXychoriumBricks = Map.colorBlock(CustomColors.class, customColors -> ColoredBlock.supplier(), (color, content) -> ((BlockContent)content.withName("Matte %s Bricks".formatted(color.name()))).withModelPath(content.id().m_135815_()).withModelType(BlockModelType.Block));
    public static final BlockContent GlassViewer = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties())).withName("Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerSilicon = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties())).withName("Silicon Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerDire = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties())).withName("Dire Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerGlowing = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties().m_60953_(state -> 15))).withName("Glowing Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerGlowingClear = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties().m_60953_(state -> 15))).withName("Glowing Clear Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerDark = ((BlockContent)Map.block(() -> new TintedGlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152498_).m_60918_(SoundType.f_154654_))).withName("Dark Glass Viewer")).withModelType(BlockModelType.Custom);
    public static final BlockContent GlassViewerReinforced = ((BlockContent)Map.block(() -> new GlassBlock(WorldContent.GlassProperties().m_155954_(Blocks.f_152550_.m_155943_()))).withName("Reinforced Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final BlockContent GlassViewerImmortal = ((BlockContent)Map.block(() -> new ImmortalGlassBlock(WorldContent.GlassProperties().m_155954_(Blocks.f_50080_.m_155943_() / 3.0f).m_155956_(9001.0f))).withName("Immortal Glass Viewer")).withModelType(BlockModelType.Connected);
    public static final EnumMap<DyeColor, BlockContent> GlassViewerRgb = Map.colorBlock(DyeColor.class, RGBGlassBlock::supplier, RGBGlassBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Viewer")).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> GlassViewerRgbGlowing = Map.colorBlock(DyeColor.class, RGBGlassBlock::supplierGlow, RGBGlassBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("Glowing RGB Viewer")).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final BlockContent GlassViewerPhantom = ((BlockContent)Map.block(() -> new PhantomGlassViewerBlock(WorldContent.GlassProperties().m_60910_())).withName("Phantom Glass Viewer")).withModelType(BlockModelType.Custom);
    public static final BlockContent GlassViewerPhantomGlowing = ((BlockContent)Map.block(() -> new PhantomGlassViewerBlock(WorldContent.GlassProperties().m_60910_().m_60953_(state -> 15))).withName("Glowing Phantom Glass Viewer")).withModelType(BlockModelType.Custom);
    public static final BlockContent GlassViewerPhantomDark = ((BlockContent)Map.block(() -> new PhantomGlassViewerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152498_).m_60910_().m_60918_(SoundType.f_154654_))).withName("Dark Phantom Glass Viewer")).withModelType(BlockModelType.Custom);
    public static final EnumMap<DyeColor, BlockContent> AureyBlockMatte = Map.colorBlock(DyeColor.class, AureyBlock::blockSupplier, AureyBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("Matte Aurey Block")).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.PINK ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> AureyBlockMatteGlowing = Map.colorBlock(DyeColor.class, AureyBlock::blockSupplierGlow, AureyBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("Glowing Matte Aurey Block")).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.PINK ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> AureyBlockFx = Map.colorBlock(DyeColor.class, AureyBlock::blockSupplier, AureyBlock::itemSupplierHidden, (color, content) -> ((BlockContent)content.withName("Shiny Aurey Block")).setTab(null).withModelType(BlockModelType.Custom).withCustomBreakRule());
    public static final EnumMap<DyeColor, BlockContent> AureyBlockFxGlowing = Map.colorBlock(DyeColor.class, AureyBlock::blockSupplierGlow, AureyBlock::itemSupplierHidden, (color, content) -> ((BlockContent)content.withName("Glowing Shiny Aurey Block")).setTab(null).withModelType(BlockModelType.Custom).withCustomBreakRule());
    public static final EnumMap<DyeColor, BlockContent> LampRgbGlowing = Map.colorBlock(DyeColor.class, LampColoredBlock::blockSupplier, LampColoredBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Lamp")).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> LampRgbGlowingInverted = Map.colorBlock(DyeColor.class, LampColoredBlock::blockSupplierInverted, LampColoredBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("Inverted RGB Lamp")).withModelPath(LampRgbGlowing.get(DyeColor.WHITE).modelPath()).withModelType(BlockModelType.Custom).withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> LampLantern = Map.colorBlock(DyeColor.class, LampLanternBlock::blockSupplier, LampLanternBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Lantern Lamp")).withModelType(BlockModelType.Custom).withCustomItemModel().withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> LampFlush = Map.colorBlock(DyeColor.class, LampFlushBlock::blockSupplier, LampFlushBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Flush Lamp")).withModelType(BlockModelType.Custom).withCustomItemModel().withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> LampCube = Map.colorBlock(DyeColor.class, LampCubeBlock::blockSupplier, LampCubeBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Cube Lamp")).withModelType(BlockModelType.Custom).withCustomItemModel().withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final EnumMap<DyeColor, BlockContent> LampPillar = Map.colorBlock(DyeColor.class, LampPillarBlock::blockSupplier, LampPillarBlock::itemSupplier, (color, content) -> {
        ((BlockContent)content.withName("RGB Pillar Lamp")).withModelType(BlockModelType.Custom).withCustomItemModel().withCustomBreakRule();
        content.setTab(color == DyeColor.WHITE ? Tab : null);
    });
    public static final TorchBlockContent CopperTorch = (TorchBlockContent)((BlockContent)Map.torch(() -> new XyTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_284180_(MapColor.f_283916_).m_60955_().m_60910_().m_60966_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_), WorldParticleContent.CopperFlame), block -> () -> new XyWallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50082_).m_284180_(MapColor.f_283916_).m_60955_().m_60910_().m_60966_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_).lootFrom((Supplier)block), WorldParticleContent.CopperFlame), (block, wall) -> () -> new StandingAndWallBlockItem((Block)block.get(), (Block)wall.get(), new Item.Properties(), Direction.DOWN)).withName("Copper Torch")).withCustomItemModel().withCustomBreakRule().withModelType(BlockModelType.Custom);
    public static final TorchBlockContent AluminumTorch = (TorchBlockContent)((BlockContent)Map.torch(() -> new XyTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_284180_(MapColor.f_283919_).m_60955_().m_60910_().m_60966_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_), WorldParticleContent.AluminumFlame), block -> () -> new XyWallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50082_).m_284180_(MapColor.f_283919_).m_60955_().m_60910_().m_60966_().m_60953_(state -> 15).m_60918_(SoundType.f_56736_).lootFrom((Supplier)block), WorldParticleContent.AluminumFlame), (block, wall) -> () -> new StandingAndWallBlockItem((Block)block.get(), (Block)wall.get(), new Item.Properties(), Direction.DOWN)).withName("Aluminum Torch")).withCustomItemModel().withCustomBreakRule().withModelType(BlockModelType.Custom);
    public static final EnumMap<CustomColors, BlockContent> XychoriumOreStone = Map.colorBlock(CustomColors.class, customColors -> () -> new OreColoredBlock((ColorSource)customColors, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)), (color, content) -> ((BlockContent)content.withName("%s Xychorium Ore".formatted(color.name()))).withModelType(BlockModelType.Cloud).withCustomBreakRule());
    public static final EnumMap<CustomColors, BlockContent> XychoriumOreDeepslate = Map.colorBlock(CustomColors.class, customColors -> () -> new OreColoredBlock((ColorSource)customColors, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)), (color, content) -> ((BlockContent)content.withName("Deepslate %s Xychorium Ore".formatted(color.name()))).withModelType(BlockModelType.Cloud).withCustomBreakRule());
    public static final EnumMap<CustomColors, BlockContent> XychoriumOreKivi = Map.colorBlock(CustomColors.class, customColors -> () -> new OreColoredBlock((ColorSource)customColors, WorldContent.KiviProperties()), (color, content) -> ((BlockContent)content.withName("Kivi %s Xychorium Ore".formatted(color.name()))).withModelType(BlockModelType.Cloud).withCustomBreakRule());
    public static final BlockContent AluminumOreStone = ((BlockContent)Map.block(() -> new XyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152505_))).withName("Aluminum Ore")).withCustomBreakRule();
    public static final BlockContent AluminumOreDeepslate = ((BlockContent)Map.block(() -> new XyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152506_))).withName("Deepslate Aluminum Ore")).withCustomBreakRule();
    public static final BlockContent AluminumOreKivi = ((BlockContent)Map.block(WorldContent::kivi).withName("Kivi Aluminum Ore")).withCustomBreakRule();
    public static final BlockContent RawAluminumBlock = (BlockContent)Map.block(() -> new XyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152599_))).withName("Raw Aluminum Block");
    public static final EnumMap<CustomColors, ItemContent> XychoriumGem = Map.item(CustomColors.class, "%s Xychorium Gems", WorldContent::itemSupplier);
    public static final ItemContent RawAluminum = ((ItemContent)Map.item().withName("Raw Aluminum")).withName("en_gb", "Raw Aluminium").withName("en_au", "Raw Aluminium");
    public static final ItemContent AluminumIngot = ((ItemContent)Map.item().withName("Aluminum Ingot")).withName("en_gb", "Aluminium Ingot").withName("en_au", "Aluminium Ingot");
    public static final ItemContent AluminumNugget = ((ItemContent)Map.item().withName("Aluminum Nugget")).withName("en_gb", "Aluminium Nugget").withName("en_au", "Aluminium Nugget");

    private static Supplier<Item> itemSupplier(CustomColors color) {
        return () -> new XyItem(new Item.Properties());
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    private static Block aluminum() {
        return new XyBlock(WorldContent.AluminumProperties());
    }

    private static Supplier<Block> aluminum(CustomColors color) {
        return () -> new ColoredBlock((ColorSource)color, WorldContent.AluminumProperties());
    }

    private static Block kivi() {
        return new XyBlock(WorldContent.KiviProperties());
    }

    private static Supplier<Block> kivi(CustomColors color) {
        return () -> new ColoredBlock((ColorSource)color, WorldContent.KiviProperties());
    }

    private static Supplier<Block> xychorium(CustomColors color) {
        return () -> new ColoredBlock((ColorSource)color, WorldContent.XychoriumProperties());
    }

    public static BlockBehaviour.Properties KiviProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60918_(SoundType.f_154677_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_());
    }

    public static BlockBehaviour.Properties AluminumProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_284180_(MapColor.f_283919_).m_60918_(SoundType.f_154663_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_());
    }

    public static BlockBehaviour.Properties GlassProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_280658_(NoteBlockInstrument.XYLOPHONE).m_60918_(SoundType.f_154654_).m_155954_(Blocks.f_50058_.m_155943_()).m_60955_().m_60922_(WorldContent::never).m_60924_(WorldContent::never).m_60960_(WorldContent::never).m_60971_(WorldContent::never);
    }

    public static BlockBehaviour.Properties XychoriumProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60918_(SoundType.f_154654_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_());
    }
}

