/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import net.creeperhost.levelio.lib.BlockIdConverter;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import org.jetbrains.annotations.Nullable;

public class Block {
    @Nullable
    public ICompoundTag blockData;
    public int legacyId = -1;
    public int legacyMeta = -1;

    public Block(ICompoundTag blockData) {
        this.blockData = blockData;
    }

    public Block(int blockId, int blockMeta) {
        this.blockData = BlockIdConverter.dataFromId(blockId, blockMeta);
        if (!BlockIdConverter.hasMapping(blockId, blockMeta)) {
            this.legacyId = blockId;
            this.legacyMeta = blockMeta;
        }
    }

    public boolean isAir() {
        return this.getName().equals("minecraft:air") || this.legacyId == 0;
    }

    public String getName() {
        if (this.blockData == null) {
            return "<unknown>:<unknown>";
        }
        String name = this.blockData.getString("Name");
        return name.isEmpty() ? "minecraft:air" : name;
    }

    public static Block newAirBlock() {
        return new Block(0, 0);
    }

    public String toString() {
        return "Block{blockData=" + this.blockData + ", legacyId=" + this.legacyId + ", legacyMeta=" + this.legacyMeta + '}';
    }
}

