/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.world.item;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ItemDefinition<T extends Item>
implements ItemLike {
    private final ResourceLocation id;
    private final String englishName;
    private final T item;
    private final ItemType type;

    public ItemDefinition(String englishName, ResourceLocation id, T item, ItemType type) {
        Objects.requireNonNull(id, "id");
        this.id = id;
        this.englishName = englishName;
        this.item = item;
        this.type = type;
    }

    public @NonNull T m_5456_() {
        return this.item;
    }

    public ItemStack itemStack() {
        return new ItemStack(this.item, 1);
    }

    public ItemStack itemStack(int stacksize) {
        return new ItemStack(this.item, stacksize);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public ItemType getType() {
        return this.type;
    }

    public static enum ItemType {
        CUSTOM,
        TOOL,
        OTHER;

    }
}

