/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.data.recipes;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
    protected final RecipeSerializer<?> serializer;

    protected RecipeBuilder(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(this.getResult(id));
    }

    protected abstract RecipeResult getResult(ResourceLocation var1);

    protected void validate(ResourceLocation id) {
    }

    protected abstract class RecipeResult
    implements FinishedRecipe {
        private final ResourceLocation id;

        public RecipeResult(ResourceLocation id) {
            this.id = id;
        }

        public @NonNull ResourceLocation m_6445_() {
            return this.id;
        }

        public @NonNull RecipeSerializer<?> m_6637_() {
            return RecipeBuilder.this.serializer;
        }

        public @Nullable JsonObject m_5860_() {
            return null;
        }

        public @Nullable ResourceLocation m_6448_() {
            return new ResourceLocation(this.id.m_135827_(), String.format("recipes/%s", this.id.m_135815_()));
        }
    }
}

