/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.PoweredFramingSawBlockEntity;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.util.FramedUtils;

public class PoweredFramingSawMenu
extends AbstractContainerMenu
implements IFramingSawMenu {
    private final PoweredFramingSawBlockEntity blockEntity;
    private final Container inputContainer;
    private final DataSlot progressSlot;
    private final DataSlot recipeIdxSlot;
    private final DataSlot recipeStatusSlot;
    private final DataSlot energySlot;
    private final FramingSawRecipeCache cache;
    private FramingSawRecipe lastRecipe = null;

    public PoweredFramingSawMenu(int windowId, Inventory inv, FriendlyByteBuf buf) {
        this(windowId, inv, inv.f_35978_.m_9236_(), buf.m_130135_());
    }

    public PoweredFramingSawMenu(int windowId, Inventory inv, Level level, BlockPos pos) {
        super((MenuType)FBContent.MENU_TYPE_POWERED_FRAMING_SAW.get(), windowId);
        BlockEntity be = level.m_7702_(pos);
        Preconditions.checkState((boolean)(be instanceof PoweredFramingSawBlockEntity));
        this.blockEntity = (PoweredFramingSawBlockEntity)be;
        this.cache = FramingSawRecipeCache.get(level.m_5776_());
        this.progressSlot = this.m_38895_(DataSlot.m_39401_());
        this.recipeIdxSlot = this.m_38895_((DataSlot)(!level.m_5776_() ? DataSlot.m_39401_() : new RecipeIndexDataSlot()));
        this.recipeStatusSlot = this.m_38895_(DataSlot.m_39401_());
        this.energySlot = this.m_38895_(DataSlot.m_39401_());
        IItemHandlerModifiable itemHandler = FramedUtils.makeMenuItemHandler((IItemHandlerModifiable)this.blockEntity.getItemHandler(), level);
        this.inputContainer = new RecipeWrapper(itemHandler);
        for (int i = 0; i <= 4; ++i) {
            int x;
            switch (i) {
                case 0: {
                    int n = 34;
                    break;
                }
                case 4: {
                    int n = 148;
                    break;
                }
                default: {
                    int n = x = 38 + i * 18;
                }
            }
            if (i >= 1 && i < 4) {
                this.m_38897_((Slot)new AdditiveSlot((IItemHandler)itemHandler, i, x, 46));
                continue;
            }
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, i, x, 46));
        }
        FramedUtils.addPlayerInvSlots(x$0 -> this.m_38897_((Slot)x$0), inv, 8, 100);
        this.recipeIdxSlot.m_6422_(-1);
    }

    public void m_38946_() {
        FramingSawRecipeMatchResult matchResult;
        this.progressSlot.m_6422_(this.blockEntity.getProgress());
        FramingSawRecipe recipe = this.blockEntity.getSelectedRecipe();
        if (this.lastRecipe != recipe) {
            this.recipeIdxSlot.m_6422_(recipe == null ? -1 : this.cache.getRecipes().indexOf(recipe));
            this.handleRecipeChange(recipe);
        }
        this.recipeStatusSlot.m_6422_((matchResult = this.blockEntity.getMatchResult()) == null ? -1 : matchResult.ordinal());
        this.energySlot.m_6422_(this.blockEntity.getEnergy());
        super.m_38946_();
    }

    private void handleRecipeChange(FramingSawRecipe recipe) {
        this.lastRecipe = recipe;
        int additiveCount = recipe != null ? recipe.getAdditives().size() : 3;
        for (int i = 0; i < 3; ++i) {
            AdditiveSlot slot = (AdditiveSlot)this.m_38853_(1 + i);
            slot.active = i < additiveCount;
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == -1) {
            this.blockEntity.selectRecipe(null);
            return true;
        }
        List<FramingSawRecipe> recipes = this.cache.getRecipes();
        if (id >= 0 && id < recipes.size()) {
            this.blockEntity.selectRecipe(recipes.get(id));
            return true;
        }
        return super.m_6366_(player, id);
    }

    public FramingSawRecipe getSelectedRecipe() {
        return this.lastRecipe;
    }

    public int getProgress() {
        return this.progressSlot.m_6501_();
    }

    public FramingSawRecipeMatchResult getMatchResult() {
        int result = this.recipeStatusSlot.m_6501_();
        return result == -1 ? null : FramingSawRecipeMatchResult.valueOf(result);
    }

    public int getEnergy() {
        return this.energySlot.m_6501_();
    }

    @Override
    public ItemStack getInputStack() {
        return this.m_38853_(0).m_7993_();
    }

    @Override
    public Container getInputContainer() {
        return this.inputContainer;
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return this.m_38853_(1 + slot).m_7993_();
    }

    @Override
    public boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.cache.getRecipes().size();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack remainder = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            remainder = stack.m_41777_();
            if (index == 4) {
                stack.m_41720_().m_7836_(stack, player.m_9236_(), player);
                if (!this.m_38903_(stack, 5, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, remainder);
            } else if (index < 5 ? !this.m_38903_(stack, 5, this.f_38839_.size(), true) : (this.cache.getMaterialValue(stack.m_41720_()) > 0 ? !this.m_38903_(stack, 0, 1, false) : !this.m_38903_(stack, 1, 4, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == remainder.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return remainder;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.isUsableByPlayer(player);
    }

    private final class RecipeIndexDataSlot
    extends DataSlot {
        private int index = -1;

        private RecipeIndexDataSlot() {
        }

        public int m_6501_() {
            return this.index;
        }

        public void m_6422_(int value) {
            this.index = value;
            PoweredFramingSawMenu.this.handleRecipeChange(value == -1 ? null : PoweredFramingSawMenu.this.cache.getRecipes().get(value));
        }
    }

    private static final class AdditiveSlot
    extends SlotItemHandler {
        private boolean active = true;

        public AdditiveSlot(IItemHandler handler, int idx, int x, int y) {
            super(handler, idx, x, y);
        }

        public boolean m_6659_() {
            return this.active || this.m_6657_();
        }

        public boolean m_280329_() {
            return this.active || this.m_6657_();
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.active && super.m_5857_(stack);
        }
    }
}

