/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.slope;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.property.SlopeType;

public final class SlopeConnectionPredicate
implements ConnectionPredicate {
    public static final SlopeConnectionPredicate INSTANCE = new SlopeConnectionPredicate();

    private SlopeConnectionPredicate() {
    }

    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        ISlopeBlock block = (ISlopeBlock)state.m_60734_();
        SlopeType type = block.getSlopeType(state);
        if (type == SlopeType.HORIZONTAL) {
            Direction dirOne = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            Direction dirTwo2 = dirOne.m_122428_();
            if (side == dirOne || side == dirTwo2) {
                return true;
            }
            if (Utils.isY(side)) {
                return edge == dirOne || edge == dirTwo2;
            }
            return false;
        }
        Direction dirOne = block.getFacing(state);
        Direction direction = dirTwo = type == SlopeType.TOP ? Direction.UP : Direction.DOWN;
        if (side == dirOne || side == dirTwo) {
            return true;
        }
        if (side.m_122434_() == dirOne.m_122427_().m_122434_()) {
            return edge == dirOne || edge == dirTwo;
        }
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        Direction dirTwo;
        ISlopeBlock block = (ISlopeBlock)state.m_60734_();
        SlopeType type = block.getSlopeType(state);
        if (type == SlopeType.HORIZONTAL) {
            Direction dirOne = ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_();
            Direction dirTwo2 = dirOne.m_122428_();
            if (side == dirOne || side == dirTwo2) {
                return Utils.isY(edge);
            }
            return false;
        }
        Direction dirOne = block.getFacing(state).m_122424_();
        Direction direction = dirTwo = type == SlopeType.TOP ? Direction.DOWN : Direction.UP;
        if (side == dirOne || side == dirTwo) {
            return edge.m_122434_() == dirOne.m_122427_().m_122434_();
        }
        return false;
    }
}

