/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.create;

import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.api.schematic.nbt.SafeNbtWriterRegistry;
import com.simibubi.create.api.schematic.requirement.SchematicRequirementRegistries;
import com.simibubi.create.api.schematic.state.SchematicStateFilterRegistry;
import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.FenceGateMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.TrapdoorMovingInteraction;
import com.simibubi.create.foundation.block.connected.CTModel;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.compat.create.FramedBlockEntityItemRequirement;
import xfacthd.framedblocks.api.compat.create.FramedBlockSafeNbtWriter;
import xfacthd.framedblocks.client.data.ConTexDataHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.create.FramedBlockMovementChecks;
import xfacthd.framedblocks.common.compat.create.schematic.nbt.FramedChiseledBookshelfSafeNbtWriter;
import xfacthd.framedblocks.common.compat.create.schematic.nbt.FramedItemFrameSafeNbtWriter;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedDoorBlockItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedFlowerPotBlockEntityItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedItemFrameBlockEntityItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedSpecialDoubleBlockItemRequirements;
import xfacthd.framedblocks.common.compat.create.schematic.state.FramedChiseledBookshelfStateFilter;
import xfacthd.framedblocks.common.util.RegisteredBE;

public final class CreateCompat {
    public static void init() {
        if (ModList.get().isLoaded("create")) {
            try {
                if (FMLEnvironment.dist.isClient()) {
                    GuardedClientAccess.init();
                }
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing client-only Create integration!", e);
            }
        }
    }

    public static void commonSetup() {
        if (ModList.get().isLoaded("create")) {
            try {
                GuardedAccess.init();
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing Create integration!", e);
            }
        }
    }

    private CreateCompat() {
    }

    private static final class GuardedClientAccess {
        private GuardedClientAccess() {
        }

        public static void init() {
            ModelProperty ctProperty = (ModelProperty)ObfuscationReflectionHelper.getPrivateValue(CTModel.class, null, (String)"CT_PROPERTY");
            ConTexDataHandler.addConTexProperty(ctProperty);
        }
    }

    private static final class GuardedAccess {
        private static final Map<RegisteredBE<?>, SchematicRequirementRegistries.BlockEntityRequirement> SPECIAL_REQUIREMENT_BLOCK_ENTITIES = Map.of(FBContent.BE_TYPE_FRAMED_FLOWER_POT, new FramedFlowerPotBlockEntityItemRequirement(), FBContent.BE_TYPE_FRAMED_ITEM_FRAME, new FramedItemFrameBlockEntityItemRequirement());
        private static final Map<RegisteredBE<?>, SafeNbtWriterRegistry.SafeNbtWriter> SPECIAL_NBT_BLOCK_ENTITIES = Map.of(FBContent.blockEntityTypeFramedChest, new FramedBlockSafeNbtWriter("inventory"), FBContent.BE_TYPE_FRAMED_SECRET_STORAGE, new FramedBlockSafeNbtWriter("inventory"), FBContent.BE_TYPE_FRAMED_ITEM_FRAME, new FramedItemFrameSafeNbtWriter(), FBContent.BE_TYPE_FRAMED_CHISELED_BOOKSHELF, new FramedChiseledBookshelfSafeNbtWriter());

        private GuardedAccess() {
        }

        public static void init() {
            try {
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_LEVER, (MovingInteractionBehaviour)new LeverMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_DOOR, (MovingInteractionBehaviour)new DoorMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_TRAP_DOOR, (MovingInteractionBehaviour)new TrapdoorMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_FENCE_GATE, (MovingInteractionBehaviour)new FenceGateMovingInteraction());
            }
            catch (Throwable t) {
                FramedBlocks.LOGGER.warn("An error occured while registering MovingInteractions for Create contraptions!", t);
            }
            FramedBlockMovementChecks movementChecks = new FramedBlockMovementChecks();
            BlockMovementChecks.registerMovementNecessaryCheck((BlockMovementChecks.MovementNecessaryCheck)movementChecks);
            BlockMovementChecks.registerMovementAllowedCheck((BlockMovementChecks.MovementAllowedCheck)movementChecks);
            BlockMovementChecks.registerBrittleCheck((BlockMovementChecks.BrittleCheck)movementChecks);
            BlockMovementChecks.registerAttachedCheck((BlockMovementChecks.AttachedCheck)movementChecks);
            BlockMovementChecks.registerNotSupportiveCheck((BlockMovementChecks.NotSupportiveCheck)movementChecks);
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOUBLE_SLAB, new FramedSpecialDoubleBlockItemRequirements((Supplier<Block>)FBContent.BLOCK_FRAMED_SLAB));
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOUBLE_PANEL, new FramedSpecialDoubleBlockItemRequirements((Supplier<Block>)FBContent.BLOCK_FRAMED_PANEL));
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOOR, FramedDoorBlockItemRequirement.INSTANCE);
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_IRON_DOOR, FramedDoorBlockItemRequirement.INSTANCE);
            for (RegisteredBE<? extends FramedBlockEntity> blockEntity : FBContent.getFramedBlockEntities()) {
                GuardedAccess.registerBlockEntityItemRequirement(blockEntity, SPECIAL_REQUIREMENT_BLOCK_ENTITIES.getOrDefault(blockEntity, FramedBlockEntityItemRequirement.INSTANCE));
                GuardedAccess.registerSafeNbtWriter(blockEntity, SPECIAL_NBT_BLOCK_ENTITIES.getOrDefault(blockEntity, FramedBlockSafeNbtWriter.INSTANCE));
            }
            GuardedAccess.registerStateFilter(FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF, new FramedChiseledBookshelfStateFilter());
        }

        private static void registerInteractionBehaviour(RegistryObject<Block> block, MovingInteractionBehaviour behaviour) {
            MovingInteractionBehaviour.REGISTRY.register((Object)((Block)block.get()), (Object)behaviour);
        }

        private static void registerBlockItemRequirement(RegistryObject<Block> type, SchematicRequirementRegistries.BlockRequirement itemRequirement) {
            SchematicRequirementRegistries.BLOCKS.register((Object)((Block)type.get()), (Object)itemRequirement);
        }

        private static void registerBlockEntityItemRequirement(RegisteredBE<?> type, SchematicRequirementRegistries.BlockEntityRequirement itemRequirement) {
            SchematicRequirementRegistries.BLOCK_ENTITIES.register(type.get(), (Object)itemRequirement);
        }

        private static void registerSafeNbtWriter(RegisteredBE<?> type, SafeNbtWriterRegistry.SafeNbtWriter writer) {
            SafeNbtWriterRegistry.REGISTRY.register(type.get(), (Object)writer);
        }

        private static void registerStateFilter(RegistryObject<Block> block, SchematicStateFilterRegistry.StateFilter filter) {
            SchematicStateFilterRegistry.REGISTRY.register((Object)((Block)block.get()), (Object)filter);
        }
    }
}

