/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDividedPanelBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDividedPanelBlock
extends AbstractFramedDoubleBlock {
    public FramedDividedPanelBlock(BlockType type) {
        super(type);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withWater()).build();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rotation.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDividedPanelBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (this.getBlockType() == BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL) {
            BlockState defState = (BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
            return new Tuple((Object)defState, (Object)((BlockState)defState.m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        }
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.get()).m_49966_();
        return new Tuple((Object)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122427_())));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (this.getBlockType() == BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL) {
            return DoubleBlockTopInteractionMode.SECOND;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        boolean vertical;
        if (edge == null) {
            return CamoGetter.NONE;
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean bl = vertical = state.m_60734_() == FBContent.BLOCK_FRAMED_DIVIDED_PANEL_VERT.get();
        if (edge == facing) {
            if (!vertical && side == Direction.DOWN || vertical && side == facing.m_122428_()) {
                return CamoGetter.FIRST;
            }
            if (!vertical && side == Direction.UP || vertical && side == facing.m_122427_()) {
                return CamoGetter.SECOND;
            }
        } else if (side == facing) {
            if (!vertical && edge == Direction.DOWN || vertical && edge == facing.m_122428_()) {
                return CamoGetter.FIRST;
            }
            if (!vertical && edge == Direction.UP || vertical && edge == facing.m_122427_()) {
                return CamoGetter.SECOND;
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        if (side == state.m_61143_((Property)FramedProperties.FACING_HOR)) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }
}

