/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedWaterloggablePressurePlateBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPressurePlateBlock
extends PressurePlateBlock
implements IFramedBlock {
    private static final Map<BlockType, BlockType> WATERLOGGING_SWITCH = Map.of(BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE);
    private final BlockType type;

    protected FramedPressurePlateBlock(BlockType type, PressurePlateBlock.Sensitivity sensitivity, BlockBehaviour.Properties props, BlockSetType blockSet) {
        super(sensitivity, props, blockSet);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_150930_((Item)FBContent.ITEM_FRAMED_HAMMER.get())) {
            if (!level.m_5776_()) {
                Utils.wrapInStateCopy((LevelAccessor)level, pos, player, ItemStack.f_41583_, false, false, () -> {
                    BlockState newState = this.getCounterpart().m_49966_();
                    level.m_46597_(pos, newState);
                });
            }
            return true;
        }
        return false;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.m_7749_(state, level, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.m_49635_(state, builder), builder);
    }

    protected int m_6693_(Level level, BlockPos pos) {
        if (this.f_55250_ == null) {
            List players = level.m_45976_(Player.class, f_49287_.m_82338_(pos));
            if (!players.isEmpty()) {
                for (Player player : players) {
                    if (player.m_6090_()) continue;
                    return 15;
                }
            }
            return 0;
        }
        return super.m_6693_(level, pos);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    protected final Block getCounterpart() {
        return FBContent.byType(WATERLOGGING_SWITCH.get(this.type));
    }

    public static FramedPressurePlateBlock wood() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.EVERYTHING, IFramedBlock.createProperties(BlockType.FRAMED_PRESSURE_PLATE).m_60910_().m_60978_(0.5f), BlockSetType.f_271198_);
    }

    public static FramedPressurePlateBlock woodWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.EVERYTHING, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE).m_60910_().m_60978_(0.5f), BlockSetType.f_271198_);
    }

    public static FramedPressurePlateBlock stone() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_STONE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.MOBS, IFramedBlock.createProperties(BlockType.FRAMED_STONE_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f), BlockSetType.f_271479_);
    }

    public static FramedPressurePlateBlock stoneWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, PressurePlateBlock.Sensitivity.MOBS, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f), BlockSetType.f_271479_);
    }

    public static FramedPressurePlateBlock obsidian() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, null, IFramedBlock.createProperties(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f), BlockSetType.f_271479_);
    }

    public static FramedPressurePlateBlock obsidianWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, null, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE).m_60999_().m_60910_().m_60978_(0.5f), BlockSetType.f_271479_);
    }
}

