/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.ConcatenatedListView;

public abstract class BlockInteractOverlay
implements IGuiOverlay {
    private static final int LINE_DIST = 3;
    private static final Target NO_TARGET = new Target(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), Direction.NORTH);
    private static final List<BlockInteractOverlay> OVERLAYS = new ArrayList<BlockInteractOverlay>();
    private final List<Component> linesFalse;
    private final List<Component> linesTrue;
    private final Texture textureFalse;
    private final Texture textureTrue;
    private final Supplier<Mode> modeGetter;
    private int textWidth = 0;
    private boolean textWidthValid = false;

    BlockInteractOverlay(List<Component> linesFalse, List<Component> linesTrue, Texture textureFalse, Texture textureTrue, Supplier<Mode> modeGetter) {
        this.linesFalse = linesFalse;
        this.linesTrue = linesTrue;
        this.textureFalse = textureFalse;
        this.textureTrue = textureTrue;
        this.modeGetter = modeGetter;
        OVERLAYS.add(this);
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        Mode mode = this.modeGetter.get();
        if (mode == Mode.HIDDEN || BlockInteractOverlay.player().m_5833_() || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        ItemStack stack = BlockInteractOverlay.player().m_21205_();
        if (!this.isValidTool(stack)) {
            return;
        }
        Target target = BlockInteractOverlay.getTargettedBlock();
        if (!this.isValidTarget(target)) {
            return;
        }
        boolean state = this.getState(target);
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        Texture tex = this.getTexture(target, state, this.textureFalse, this.textureTrue);
        int texX = centerX + 20;
        int texY = centerY - tex.height / 2;
        tex.draw(gui, graphics, texX, texY);
        this.renderAfterIcon(gui, graphics, tex, texX, texY, target);
        if (mode == Mode.DETAILED) {
            List<Component> lines = this.getLines(target, state, this.linesFalse, this.linesTrue);
            this.renderDetailed(gui, graphics, tex, lines, centerX, screenHeight, target);
        }
    }

    private void renderDetailed(ForgeGui gui, GuiGraphics graphics, Texture tex, List<Component> lines, int centerX, int screenHeight, Target target) {
        Font font = gui.m_93082_();
        if (!this.textWidthValid) {
            this.updateTextWidth(font);
        }
        Objects.requireNonNull(font);
        int lineHeight = 9 + 3;
        int count = lines.size();
        int contentHeight = count * lineHeight - 3;
        int width = this.textWidth + tex.width + 10;
        int height = Math.max(contentHeight, tex.height);
        int x = centerX - width / 2;
        int y = screenHeight - 80 - height;
        BlockInteractOverlay.drawTooltipBackground(graphics, x, y, width, height);
        int textX = x + tex.width + 10;
        int yBaseOff = tex.height > contentHeight ? (tex.height - contentHeight) / 2 : 0;
        for (int i = 0; i < count; ++i) {
            Component text = lines.get(i);
            int yOff = yBaseOff + lineHeight * i;
            graphics.m_280430_(font, text, textX, y + yOff, -1);
        }
        int texY = y + height / 2 - tex.height / 2;
        tex.draw(gui, graphics, x, texY);
        this.renderAfterIcon(gui, graphics, tex, x, texY, target);
    }

    protected abstract boolean isValidTool(ItemStack var1);

    protected abstract boolean isValidTarget(Target var1);

    protected abstract boolean getState(Target var1);

    protected Texture getTexture(Target target, boolean state, Texture texFalse, Texture texTrue) {
        return state ? texTrue : texFalse;
    }

    protected List<Component> getLines(Target target, boolean state, List<Component> linesFalse, List<Component> linesTrue) {
        return state ? linesTrue : linesFalse;
    }

    protected void renderAfterIcon(ForgeGui gui, GuiGraphics graphics, Texture tex, int texX, int texY, Target target) {
    }

    private void updateTextWidth(Font font) {
        this.textWidth = 0;
        for (Component line : ConcatenatedListView.of((List[])new List[]{this.linesFalse, this.linesTrue})) {
            this.textWidth = Math.max(this.textWidth, font.m_92852_((FormattedText)line));
        }
        this.textWidthValid = true;
    }

    public static void onResourceReload(ResourceManager manager) {
        OVERLAYS.forEach(overlay -> {
            overlay.textWidthValid = false;
        });
    }

    protected static BlockGetter level() {
        return (BlockGetter)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    protected static Player player() {
        return (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
    }

    protected static Target getTargettedBlock() {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.m_82425_();
            return new Target(pos, BlockInteractOverlay.level().m_8055_(pos), blockHit.m_82434_());
        }
        return NO_TARGET;
    }

    private static void drawTooltipBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_286007_(() -> TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)(x - 2), (int)(y - 2), (int)(width + 4), (int)(height + 4), (int)0));
    }

    protected record Texture(ResourceLocation location, int xOff, int yOff, int width, int height, int texWidth, int texHeight) {
        public void draw(ForgeGui gui, GuiGraphics graphics, int x, int y) {
            gui.setupOverlayRenderState(true, false);
            graphics.m_280398_(this.location, x, y, 0, (float)this.xOff, (float)this.yOff, this.width, this.height, this.texWidth, this.texHeight);
        }
    }

    public static enum Mode {
        HIDDEN,
        ICON,
        DETAILED;

    }

    protected record Target(BlockPos pos, BlockState state, Direction side) {
    }
}

