/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.ghost;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.ghost.CamoPair;
import xfacthd.framedblocks.api.ghost.GhostRenderBehaviour;
import xfacthd.framedblocks.client.render.special.GhostBlockRenderer;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public final class BlueprintGhostRenderBehaviour
implements GhostRenderBehaviour {
    @Override
    @Nullable
    public ItemStack getProxiedStack(ItemStack stack) {
        Item item = FramedBlueprintItem.getTargetBlock(stack).m_5456_();
        if (item instanceof BlockItem) {
            ItemStack proxied = new ItemStack((ItemLike)item);
            if (stack.m_41782_() && stack.m_41783_().m_128441_("blueprint_data")) {
                proxied.m_41784_().m_128365_("BlockEntityTag", (Tag)stack.m_41783_().m_128469_("blueprint_data").m_128469_("camo_data"));
            }
            return proxied;
        }
        return null;
    }

    @Override
    public boolean mayRender(ItemStack stack, @Nullable ItemStack proxiedStack) {
        return proxiedStack != null && BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).mayRender(proxiedStack, null);
    }

    @Override
    public boolean hasSecondBlock(ItemStack stack, @Nullable ItemStack proxiedStack) {
        return proxiedStack != null && BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).hasSecondBlock(proxiedStack, null);
    }

    @Override
    @Nullable
    public BlockState getRenderState(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, boolean secondPass) {
        if (proxiedStack == null) {
            return null;
        }
        return BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).getRenderState(proxiedStack, null, hit, ctx, hitState, secondPass);
    }

    @Override
    public BlockPos getRenderPos(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockPos defaultPos, boolean secondPass) {
        if (proxiedStack == null) {
            return null;
        }
        return BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).getRenderPos(proxiedStack, null, hit, ctx, hitState, defaultPos, secondPass);
    }

    @Override
    public boolean canRenderAt(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockState renderState, BlockPos renderPos) {
        if (proxiedStack == null) {
            return false;
        }
        return BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).canRenderAt(proxiedStack, null, hit, ctx, hitState, renderState, renderPos);
    }

    @Override
    public CamoPair readCamo(ItemStack stack, @Nullable ItemStack proxiedStack, boolean secondPass) {
        if (proxiedStack != null && stack.m_41782_() && stack.m_41783_().m_128441_("blueprint_data")) {
            CompoundTag tag = stack.m_41698_("blueprint_data");
            Set<CamoContainer> camos = FramedBlueprintItem.getCamoContainers((BlockItem)proxiedStack.m_41720_(), tag);
            Iterator<CamoContainer> it = camos.iterator();
            BlockState camoState = it.next().getState();
            BlockState camoStateTwo = null;
            if (it.hasNext()) {
                camoStateTwo = it.next().getState();
            }
            return new CamoPair(camoState, camoStateTwo);
        }
        return CamoPair.EMPTY;
    }

    @Override
    public CamoPair postProcessCamo(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, boolean secondPass, CamoPair camo) {
        if (proxiedStack == null) {
            return CamoPair.EMPTY;
        }
        return BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).postProcessCamo(proxiedStack, null, ctx, renderState, secondPass, camo);
    }

    @Override
    public ModelData appendModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, boolean secondPass, ModelData data) {
        if (proxiedStack == null) {
            return data;
        }
        return BlueprintGhostRenderBehaviour.proxyBehaviour(proxiedStack).appendModelData(proxiedStack, null, ctx, renderState, secondPass, data);
    }

    private static GhostRenderBehaviour proxyBehaviour(ItemStack proxiedStack) {
        return GhostBlockRenderer.getBehaviour(proxiedStack.m_41720_());
    }
}

