/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.compat.create;

import com.simibubi.create.api.schematic.requirement.SchematicRequirementRegistries;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.util.Utils;

public class FramedBlockEntityItemRequirement
implements SchematicRequirementRegistries.BlockEntityRequirement {
    public static final FramedBlockEntityItemRequirement INSTANCE = new FramedBlockEntityItemRequirement();

    protected FramedBlockEntityItemRequirement() {
    }

    public final ItemRequirement getRequiredItems(BlockEntity blockEntity, BlockState state) {
        if (blockEntity instanceof FramedBlockEntity) {
            IFramedDoubleBlockEntity fdbe;
            CamoContainer camoTwo;
            FramedBlockEntity fbe = (FramedBlockEntity)blockEntity;
            ArrayList<ItemRequirement.StackRequirement> requirements = new ArrayList<ItemRequirement.StackRequirement>();
            CamoContainer camoOne = fbe.getCamo();
            if (!camoOne.isEmpty() && camoOne.getType().isBlock()) {
                requirements.add(FramedBlockEntityItemRequirement.consume(camoOne.toItemStack(ItemStack.f_41583_)));
            }
            if (fbe instanceof IFramedDoubleBlockEntity && !(camoTwo = (fdbe = (IFramedDoubleBlockEntity)((Object)fbe)).getCamoTwo()).isEmpty() && camoTwo.getType().isBlock()) {
                requirements.add(FramedBlockEntityItemRequirement.consume(camoTwo.toItemStack(ItemStack.f_41583_)));
            }
            if (fbe.isGlowing()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)Items.f_42525_));
            }
            if (fbe.isMarkedIntangible()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)FramedBlocksAPI.getInstance().getIntangibilityMarkerItem()));
            }
            if (fbe.isReinforced()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)Utils.FRAMED_REINFORCEMENT.get()));
            }
            this.collectAdditionalRequirements(fbe, requirements);
            return new ItemRequirement(requirements);
        }
        return ItemRequirement.NONE;
    }

    protected void collectAdditionalRequirements(FramedBlockEntity blockEntity, List<ItemRequirement.StackRequirement> requirements) {
    }

    protected static ItemRequirement.StackRequirement consume(ItemLike item) {
        return FramedBlockEntityItemRequirement.consume(new ItemStack(item));
    }

    protected static ItemRequirement.StackRequirement consume(ItemStack stack) {
        return new ItemRequirement.StackRequirement(stack, ItemRequirement.ItemUseType.CONSUME);
    }

    protected static ItemRequirement.StackRequirement consumeStrict(ItemStack stack) {
        return new ItemRequirement.StrictNbtStackRequirement(stack, ItemRequirement.ItemUseType.CONSUME);
    }
}

