/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_optimization.config;

import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_optimization.config.JsonConfig;

public final class Config
extends JsonConfig {
    private static Config INSTANCE = Config.loadOrCreate(new Config(), Config.class);
    public String _documentation = "https://github.com/Luke100000/ImmersiveOptimization/wiki";
    public boolean enableEntities = true;
    public boolean enableBlockEntities = true;
    public boolean enableDistanceCulling = true;
    public boolean enableTrackingCulling = true;
    public boolean enableViewportCulling = true;
    public int minDistance = 6;
    public int blocksPerLevel = 64;
    public int blocksPerLevelDistanceCulled = 10;
    public int blocksPerLevelTrackingCulled = 10;
    public int blocksPerLevelViewportCulled = 20;
    public int maxLevel = 20;
    public int blocksPerLevelBlockEntities = 32;
    public int stressedThreshold = 45;
    public float minDecreaseFactor = 0.25f;
    public Map<String, Boolean> dimensions = new HashMap<String, Boolean>();
    public Map<String, Boolean> entities;

    public Config() {
        super("immersive_optimization");
        this.dimensions.put("minecraft:overworld", true);
        this.dimensions.put("minecraft:the_nether", true);
        this.dimensions.put("minecraft:the_end", true);
        this.entities = new HashMap<String, Boolean>();
        this.entities.put("minecraft:player", false);
        this.entities.put("minecraft:ender_dragon", false);
        this.entities.put("minecraft:arrow", false);
        this.entities.put("minecraft:ender_pearl", false);
        this.entities.put("fromanotherworld:starship", false);
        this.entities.put("create", false);
        this.entities.put("valkyrienskies", false);
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    @Override
    int getVersion() {
        return 2;
    }

    public void reload() {
        INSTANCE = Config.loadOrCreate(new Config(), Config.class);
    }
}

