/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.blocks.table_saws;

import de.geheimagentnr1.manyideas_core.elements.blocks.table_saws.TableSawMenu;
import de.geheimagentnr1.manyideas_core.elements.blocks.table_saws.TableSawRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TableSawScreen
extends AbstractContainerScreen<TableSawMenu> {
    @NotNull
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("manyideas_core", "textures/gui/table_saws/table_saw_gui.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public TableSawScreen(@NotNull TableSawMenu _menu, @NotNull Inventory _inventory, @NotNull Component _title) {
        super((AbstractContainerMenu)_menu, _inventory, _title);
        _menu.setInventoryUpdateListener(this::containerChanged);
        this.initData();
    }

    private void initData() {
        --this.f_97729_;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int x, int y) {
        this.m_280273_(guiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, x, y, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        this.m_280072_(guiGraphics, x, y);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<TableSawRecipe> list = ((TableSawMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((TableSawMenu)this.f_97732_).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + (i1 % 4 << 4);
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.m_280072_(guiGraphics, x, y);
            }
        }
    }

    private void renderButtons(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int recipeIndexOffsetMax) {
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((TableSawMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + (j % 4 << 4);
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((TableSawMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(@NotNull GuiGraphics guiGraphics, int left, int top, int recipeIndexOffsetMax) {
        List<TableSawRecipe> list = ((TableSawMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((TableSawMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + (j % 4 << 4);
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            guiGraphics.m_280480_(list.get(i).getResult(), k, i1);
        }
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = p_231044_1_ - (double)(i + (i1 % 4 << 4));
                double d1 = p_231044_3_ - ((double)j + (double)i1 / 4.0 * 18.0);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((TableSawMenu)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((TableSawMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            int i1 = this.f_97735_ + 119;
            int i2 = this.f_97736_ + 9;
            if (p_231044_1_ >= (double)i1 && p_231044_1_ < (double)(i1 + 12) && p_231044_3_ >= (double)i2 && p_231044_3_ < (double)(i2 + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    public boolean m_7979_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)p_231045_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) << 2;
            return true;
        }
        return super.m_7979_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean m_6050_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - p_231043_5_ / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) << 2;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((TableSawMenu)this.f_97732_).getNumRecipes() > 12;
    }

    private int getOffscreenRows() {
        return (((TableSawMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((TableSawMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

