/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class CompiledDetectorModule
extends CompiledModule {
    public static final String NBT_SIGNAL_LEVEL = "SignalLevel";
    public static final String NBT_STRONG_SIGNAL = "StrongSignal";
    private final int signalLevel;
    private final boolean strongSignal;

    public CompiledDetectorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        this.signalLevel = compound.m_128441_(NBT_SIGNAL_LEVEL) ? (int)compound.m_128445_(NBT_SIGNAL_LEVEL) : 15;
        this.strongSignal = compound.m_128471_(NBT_STRONG_SIGNAL);
    }

    @Override
    public boolean hasTarget() {
        return true;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        ItemStack stack = router.getBufferItemStack();
        if (!this.getFilter().test(stack)) {
            return false;
        }
        router.emitRedstone(this.getDirection(), this.getSignalLevel(), DetectorModule.SignalType.getType(this.isStrongSignal()));
        return true;
    }

    public int getSignalLevel() {
        return this.signalLevel;
    }

    public boolean isStrongSignal() {
        return this.strongSignal;
    }

    @Override
    public void onCompiled(ModularRouterBlockEntity router) {
        super.onCompiled(router);
        router.setAllowRedstoneEmission(true);
    }

    @Override
    public void cleanup(ModularRouterBlockEntity router) {
        super.cleanup(router);
        router.setAllowRedstoneEmission(false);
    }
}

