/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class ContainsLootConditionTest {
    private static final Vec3 TEST_POS = new Vec3(0.0, 0.0, 0.0);

    @GameTest(m_177046_="empty_test_structure")
    public void nonExactCheck(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), TEST_POS);
        GameTestUtils.fillExampleLoot(ctx, Items.f_42415_, Items.f_42472_);
        ContainsLootCondition c = new ContainsLootCondition(itemStack -> itemStack.m_41720_() == Items.f_42415_, false);
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, c.test(ctx), "Should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void exactCheck(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), TEST_POS);
        GameTestUtils.fillExampleLoot(ctx, Items.f_42415_, Items.f_42472_);
        ContainsLootCondition c = new ContainsLootCondition(itemStack -> itemStack.m_41720_() == Items.f_42415_ || itemStack.m_41720_() == Items.f_42472_, true);
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, c.test(ctx), "Should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void exactCheck_fail(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), TEST_POS);
        GameTestUtils.fillExampleLoot(ctx, Items.f_42415_, Items.f_42472_);
        ContainsLootCondition c = new ContainsLootCondition(ItemFilter.ARMOR, true);
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, c.test(ctx), "Should fail, because of diamond is not armor"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void simpleCheck_fail(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), TEST_POS);
        GameTestUtils.fillExampleLoot(ctx, Items.f_42415_, Items.f_42472_);
        ContainsLootCondition c = new ContainsLootCondition(itemStack -> itemStack.m_41720_() == Items.f_42691_, false);
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, c.test(ctx), "Should fail"));
    }
}

