/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import net.creeperhost.polylib.io.sentry.DateUtils;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.SentryOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DateSerializerAdapter
implements JsonSerializer<Date> {
    @NotNull
    private final SentryOptions options;

    public DateSerializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public JsonElement serialize(@Nullable Date src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        try {
            return src == null ? null : new JsonPrimitive(DateUtils.getTimestamp(src));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when serializing Date", e);
            return null;
        }
    }
}

