/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketTeamIdSync;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class TeamCommand {
    private static final Component CREATE_TEAM_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.create.success");
    private static final Component CREATE_TEAM_FAIL_IN_TEAM = Component.m_237115_((String)"shetiphiancore.team.create.fail.inteam");
    private static final Component CREATE_TEAM_FAIL_EXISTS = Component.m_237115_((String)"shetiphiancore.team.create.fail.exists");
    private static final String RENAME_SUCCESS = "shetiphiancore.team.rename.success";
    private static final Component RENAME_FAIL = Component.m_237115_((String)"shetiphiancore.team.rename.fail.same");
    private static final Component SEND_INVITE_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.invite.send.success");
    private static final Component SEND_INVITE_FAIL_ALREADY_MEMBER = Component.m_237115_((String)"shetiphiancore.team.invite.send.fail.member");
    private static final String SEND_INVITE_FAIL_PENDING = "shetiphiancore.team.invite.send.fail.pending";
    private static final String INVITE_NOTICE = "shetiphiancore.team.invite.receive.notice";
    private static final String ACCEPT_INVITE_SUCCESS = "shetiphiancore.team.invite.accept.success";
    private static final String ACCEPT_INVITE_SUCCESS_NOTICE = "shetiphiancore.team.invite.accept.success.notice";
    private static final Component ACCEPT_INVITE_FAIL_PERMISSIONS = Component.m_237115_((String)"shetiphiancore.team.invite.accept.fail.permissions");
    private static final Component ACCEPT_INVITE_FAIL_MEMBER = Component.m_237115_((String)"shetiphiancore.team.invite.accept.fail.member");
    private static final Component ACCEPT_INVITE_FAIL_IN_TEAM = Component.m_237115_((String)"shetiphiancore.team.invite.accept.fail.inteam");
    private static final Component ACCEPT_INVITE_FAIL_NO_INVITE = Component.m_237115_((String)"shetiphiancore.team.invite.accept.fail.noinvite");
    private static final Component LEAVE_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.leave.success");
    private static final String LEAVE_SUCCESS_NOTICE = "shetiphiancore.team.leave.success.notice";
    private static final Component LEAVE_FAILED_LEADER = Component.m_237115_((String)"shetiphiancore.team.leave.fail.leader");
    private static final Component KICK_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.kick.success");
    private static final Component KICK_SUCCESS_NOTICE = Component.m_237115_((String)"shetiphiancore.team.kick.success.notice");
    private static final Component KICK_FAIL_RANK = Component.m_237115_((String)"shetiphiancore.team.kick.fail.rank");
    private static final Component KICK_FAIL_WRONG_TEAM = Component.m_237115_((String)"shetiphiancore.team.kick.fail.team");
    private static final Component PROMOTE_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.rank.promote.success");
    private static final Component PROMOTED = Component.m_237115_((String)"shetiphiancore.team.rank.promote.success.notice");
    private static final Component PROMOTE_FAIL_ALREADY_MANAGER = Component.m_237115_((String)"shetiphiancore.team.rank.promote.fail.manager");
    private static final Component PROMOTE_FAIL_USER_NOT_IN_TEAM = Component.m_237115_((String)"shetiphiancore.team.rank.promote.fail.not_member");
    private static final Component DEMOTE_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.rank.demote.success");
    private static final Component DEMOTED = Component.m_237115_((String)"shetiphiancore.team.rank.demote.success.notice");
    private static final Component DEMOTE_SELF_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.rank.demote.success.self");
    private static final Component TRANSFER_SUCCESS = Component.m_237115_((String)"shetiphiancore.team.transfer.success");
    private static final String TRANSFER_SUCCESS_NOTICE = "shetiphiancore.team.transfer.success.notice";
    private static final Component TRANSFER_FAIL_SAME = Component.m_237115_((String)"shetiphiancore.team.transfer.fail.same");
    private static final String DISBAND_SUCCESS = "shetiphiancore.team.disband.success";
    private static final Component NO_TEAMS = Component.m_237115_((String)"shetiphiancore.team.no_teams");
    private static final Component TEAM_HAS_NO_MEMBERS = Component.m_237115_((String)"shetiphiancore.team.members.empty");
    private static final Component TEAM_DOESNT_EXIST = Component.m_237115_((String)"shetiphiancore.team.members.error.noteam");
    private static final Component YOUR_NOT_IN_A_TEAM = Component.m_237115_((String)"shetiphiancore.team.error.no_team");
    private static final Component YOUR_NOT_THE_TEAM_LEADER = Component.m_237115_((String)"shetiphiancore.team.error.not_leader");
    private static final Component YOUR_NOT_A_TEAM_MANAGER = Component.m_237115_((String)"shetiphiancore.team.error.not_manager.self");
    private static final Component PLAYER_NOT_A_TEAM_MANAGER = Component.m_237115_((String)"shetiphiancore.team.error.not_manager.other");
    private static final String SYSADMIN_CREATE_TEAM = "shetiphiancore.team.sysadmin.create.success";
    private static final String SYSADMIN_RENAME_SUCCESS = "shetiphiancore.team.sysadmin.rename.success";
    private static final String SYSADMIN_KICK_SUCCESS = "shetiphiancore.team.sysadmin.kick.success";
    private static final String SYSADMIN_KICKED_FROM_TEAM = "shetiphiancore.team.sysadmin.kick.inform";
    private static final String SYSADMIN_ADD_SUCCESS = "shetiphiancore.team.sysadmin.add.success";
    private static final String SYSADMIN_ADDED_TO_TEAM = "shetiphiancore.team.sysadmin.add.inform";
    private static final String SYSADMIN_TRANSFER_SUCCESS = "shetiphiancore.team.sysadmin.transfer.success";
    private static final String SYSADMIN_DISBAND_SUCCESS = "shetiphiancore.team.sysadmin.disband.success";
    private static final String SYSADMIN_TEAM_DISBANDED = "shetiphiancore.team.sysadmin.disband.inform";
    private static final Cache<ServerPlayer, Pair<PlayerTeam, Player>> INVITE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final String RANK_LEADER = "\u25c6 ";
    private static final String RANK_MANAGER = "\u25c7 ";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spc_teams").then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"teamId", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), (Component)Component.m_237119_()))).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.rename((CommandSourceStack)context.getSource(), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName")))))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.invite((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"accept").executes(context -> TeamCommand.accept((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"leave").executes(context -> TeamCommand.leave((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.kick((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"promote").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.promote((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"demote").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.demote((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommand.transfer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"disband").executes(context -> TeamCommand.disband((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"teams").executes(context -> TeamCommand.teams((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), null))).then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spc_teams_sysadmin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"teamId", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> TeamCommand.sysadmin_createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), (Component)Component.m_237119_()))).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.sysadmin_createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"displayName", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> TeamCommand.sysadmin_rename((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), ComponentArgument.m_87117_((CommandContext)context, (String)"displayName"))))))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"inform", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_kick((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"inform"))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_add((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.m_91477_((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_transfer((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.m_91474_((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.m_82127_((String)"disband").then(Commands.m_82129_((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.sysadmin_disband((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"msg_team").then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(context -> TeamCommand.teamMessage((CommandSourceStack)context.getSource(), MessageArgument.m_96835_((CommandContext)context, (String)"message")))));
    }

    private static Pair<String, Component> processTeamIdentity(ResourceLocation id, Component displayName) {
        Object teamId = (String)(id.m_135827_().equals("minecraft") ? "" : id.m_135827_() + ":") + id.m_135815_();
        if (Strings.isNullOrEmpty((String)displayName.getString())) {
            displayName = Component.m_237113_((String)teamId);
        }
        teamId = ((String)teamId).replaceAll(":", "-").replaceAll("/", ".");
        return Pair.of((Object)teamId, (Object)displayName);
    }

    private static int createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            Pair<String, Component> identity = TeamCommand.processTeamIdentity(teamId, displayName);
            if (!TeamHelper.doesTeamExist((String)identity.getLeft())) {
                if (TeamHelper.getTeam((Player)executor) == null) {
                    PlayerTeam.create((String)identity.getLeft(), (Player)executor, (Component)identity.getRight());
                    source.m_288197_(() -> CREATE_TEAM_SUCCESS, false);
                } else {
                    source.m_81352_(CREATE_TEAM_FAIL_IN_TEAM);
                }
            } else {
                source.m_81352_(CREATE_TEAM_FAIL_EXISTS);
            }
        }
        return 0;
    }

    private static int rename(CommandSourceStack source, Component displayName) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_20148_())) {
                    Component oldName = eTeam.getDisplayName();
                    if (eTeam.changeDisplayName(displayName)) {
                        MutableComponent message = Component.m_237110_((String)RENAME_SUCCESS, (Object[])new Object[]{oldName, eTeam.getDisplayName()});
                        source.m_288197_(() -> message, false);
                    } else {
                        source.m_81352_(RENAME_FAIL);
                    }
                } else {
                    source.m_81352_(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int invite(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_20148_())) {
                    Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
                    if (cachedInvite == null) {
                        if (!eTeam.equals(TeamHelper.getTeam(target.m_20148_()))) {
                            MutableComponent invite = Component.m_237110_((String)INVITE_NOTICE, (Object[])new Object[]{eTeam.getDisplayName(), "'/spc_teams accept'", 15});
                            target.m_213846_((Component)invite);
                            INVITE_CACHE.put((Object)target, (Object)Pair.of((Object)eTeam, (Object)executor));
                            source.m_288197_(() -> SEND_INVITE_SUCCESS, false);
                        } else {
                            source.m_81352_(SEND_INVITE_FAIL_ALREADY_MEMBER);
                        }
                    } else {
                        MutableComponent invite = Component.m_237110_((String)SEND_INVITE_FAIL_PENDING, (Object[])new Object[]{((PlayerTeam)cachedInvite.getLeft()).getDisplayName()});
                        target.m_213846_((Component)invite);
                    }
                } else {
                    source.m_81352_(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int accept(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
            if (cachedInvite != null) {
                PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
                if (eTeam == null) {
                    PlayerTeam team = (PlayerTeam)cachedInvite.getLeft();
                    if (team.isManager(((Player)cachedInvite.getRight()).m_20148_())) {
                        TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), executor, true);
                        team.add((Player)executor);
                        MutableComponent invite = Component.m_237110_((String)ACCEPT_INVITE_SUCCESS, (Object[])new Object[]{team.getDisplayName()});
                        source.m_288197_(() -> invite, false);
                    } else {
                        source.m_81352_(ACCEPT_INVITE_FAIL_PERMISSIONS);
                    }
                } else if (eTeam.equals(cachedInvite.getLeft())) {
                    source.m_81352_(ACCEPT_INVITE_FAIL_MEMBER);
                } else {
                    source.m_81352_(ACCEPT_INVITE_FAIL_IN_TEAM);
                }
            } else {
                source.m_81352_(ACCEPT_INVITE_FAIL_NO_INVITE);
            }
        }
        return 0;
    }

    private static int leave(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eId = executor.m_20148_();
                if (!eId.equals(eTeam.getLeader())) {
                    eTeam.leave((Player)executor);
                    source.m_288197_(() -> LEAVE_SUCCESS, false);
                    TeamCommand.notifyTeam(source.m_81377_(), eTeam.getMembers(), executor, false);
                } else {
                    source.m_81352_(LEAVE_FAILED_LEADER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static void notifyTeam(MinecraftServer server, List<UUID> members, ServerPlayer player, boolean joining) {
        MutableComponent message = Component.m_237110_((String)(joining ? ACCEPT_INVITE_SUCCESS_NOTICE : LEAVE_SUCCESS_NOTICE), (Object[])new Object[]{player.m_5446_()});
        server.m_6846_().m_11314_().forEach(serverPlayer -> {
            if (members.contains(serverPlayer.m_20148_())) {
                serverPlayer.m_213846_((Component)message);
            }
        });
    }

    private static int kick(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            if (executor.equals((Object)target)) {
                return TeamCommand.leave(source);
            }
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eID = executor.m_20148_();
                if (eTeam.equals(TeamHelper.getTeam(target.m_20148_()))) {
                    if (eID.equals(eTeam.getLeader()) || eTeam.isManager(eID) && !eTeam.isManager(target.m_20148_())) {
                        eTeam.kick((Player)target);
                        target.m_213846_(KICK_SUCCESS_NOTICE);
                        source.m_288197_(() -> KICK_SUCCESS, false);
                    } else {
                        source.m_81352_(KICK_FAIL_RANK);
                    }
                } else {
                    source.m_81352_(KICK_FAIL_WRONG_TEAM);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int promote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_20148_())) {
                    if (eTeam.getMembers().contains(target.m_20148_())) {
                        if (eTeam.promote((Player)target)) {
                            target.m_213846_(PROMOTED);
                            source.m_288197_(() -> PROMOTE_SUCCESS, false);
                        } else {
                            source.m_81352_(PROMOTE_FAIL_ALREADY_MANAGER);
                        }
                    } else {
                        source.m_81352_(PROMOTE_FAIL_USER_NOT_IN_TEAM);
                    }
                } else {
                    source.m_81352_(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int demote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.m_20148_())) {
                    if (eTeam.demote((Player)target)) {
                        if (executor.equals((Object)target)) {
                            source.m_288197_(() -> DEMOTE_SELF_SUCCESS, false);
                        } else {
                            target.m_213846_(DEMOTED);
                            source.m_288197_(() -> DEMOTE_SUCCESS, false);
                        }
                    } else {
                        source.m_81352_(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.m_81352_(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int transfer(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.m_20148_().equals(eTeam.getLeader())) {
                    if (eTeam.isManager(target.m_20148_())) {
                        if (eTeam.transfer((Player)target)) {
                            MutableComponent message = Component.m_237110_((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{eTeam.getDisplayName()});
                            target.m_213846_((Component)message);
                            source.m_288197_(() -> TRANSFER_SUCCESS, false);
                        } else {
                            source.m_81352_(TRANSFER_FAIL_SAME);
                        }
                    } else {
                        source.m_81352_(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.m_81352_(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int disband(CommandSourceStack source) {
        Entity e = source.m_81373_();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.m_20148_().equals(eTeam.getLeader())) {
                    MutableComponent message = Component.m_237110_((String)DISBAND_SUCCESS, (Object[])new Object[]{eTeam.getDisplayName()});
                    List<UUID> players = TeamHelper.deleteTeam(eTeam.getId());
                    source.m_81377_().m_6846_().m_11314_().forEach(serverPlayer -> {
                        UUID uuid = serverPlayer.m_20148_();
                        if (players.contains(uuid)) {
                            serverPlayer.m_213846_((Component)message);
                        }
                    });
                } else {
                    source.m_81352_(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int teams(CommandSourceStack source) {
        Set<String> teams = TeamHelper.getTeams();
        if (!teams.isEmpty()) {
            MutableComponent message = Component.m_237113_((String)"\u00a77\u00a7o<teamId> ['<displayName>']\u00a7r");
            teams.forEach(id -> message.m_130946_("\u00a75 :: \u00a7f").m_130946_(id).m_130946_("\u00a77 ['\u00a7f").m_7220_(TeamHelper.getTeamDisplayName(id)).m_130946_("\u00a77']"));
            message.m_130946_("\u00a7r");
            source.m_288197_(() -> message, false);
            if (source.m_81377_().m_6992_() && source.m_230896_() != null) {
                NetworkHandler.sendToPlayer(new PacketTeamIdSync(teams), source.m_230896_());
            }
        } else {
            source.m_81352_(NO_TEAMS);
        }
        return 0;
    }

    private static int info(CommandSourceStack source, String teamId) {
        Entity e;
        if (teamId == null && (e = source.m_81373_()) instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                teamId = eTeam.getId();
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
                return 0;
            }
        }
        if (TeamHelper.doesTeamExist(teamId)) {
            PlayerTeam eTeam = TeamHelper.getTeam(teamId);
            if (eTeam != null) {
                MutableComponent message = Component.m_237113_((String)"\u00a7f").m_130946_(teamId).m_130946_("\u00a77 ['\u00a7f").m_7220_(eTeam.getDisplayName()).m_130946_("\u00a77']");
                List<UUID> members = eTeam.getMembers();
                if (!members.isEmpty()) {
                    UUID leader = eTeam.getLeader();
                    if (leader != null) {
                        message.m_130946_("\n");
                        message.m_130946_(RANK_LEADER + NameHelper.getLastKnownUsername(leader));
                    }
                    StringBuilder bldManagers = new StringBuilder();
                    eTeam.getManagers().forEach(manager -> {
                        if (!manager.equals(leader)) {
                            bldManagers.append(NameHelper.getLastKnownUsername(manager)).append(", ");
                        }
                    });
                    if (bldManagers.length() > 0) {
                        String names = bldManagers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.m_130946_("\n");
                        message.m_130946_(RANK_MANAGER + names);
                    }
                    StringBuilder bldMembers = new StringBuilder();
                    members.forEach(member -> {
                        if (!eTeam.isManager((UUID)member)) {
                            bldMembers.append(NameHelper.getLastKnownUsername(member)).append(", ");
                        }
                    });
                    if (bldMembers.length() > 0) {
                        String names = bldMembers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.m_130946_("\n");
                        message.m_130946_(names);
                    }
                } else {
                    message.m_7220_(TEAM_HAS_NO_MEMBERS);
                }
                source.m_288197_(() -> message, false);
            }
        } else {
            source.m_81352_(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        Pair<String, Component> identity = TeamCommand.processTeamIdentity(teamId, displayName);
        if (!TeamHelper.doesTeamExist((String)identity.getLeft())) {
            PlayerTeam team = PlayerTeam.create((String)identity.getLeft(), null, (Component)identity.getRight());
            source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_CREATE_TEAM, (Object[])new Object[]{team.getId(), team.getDisplayName()}), true);
        } else {
            source.m_81352_(CREATE_TEAM_FAIL_EXISTS);
        }
        return 0;
    }

    private static int sysadmin_rename(CommandSourceStack source, String teamId, Component displayName) {
        PlayerTeam eTeam = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (eTeam != null) {
            Component oldName = eTeam.getDisplayName();
            if (eTeam.changeDisplayName(displayName)) {
                source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_RENAME_SUCCESS, (Object[])new Object[]{teamId, oldName, eTeam.getDisplayName()}), true);
            } else {
                source.m_81352_(RENAME_FAIL);
            }
        } else {
            source.m_81352_(YOUR_NOT_IN_A_TEAM);
        }
        return 0;
    }

    private static int sysadmin_kick(CommandSourceStack source, Collection<ServerPlayer> players, boolean inform) {
        AtomicInteger counter = new AtomicInteger();
        MutableComponent names = Component.m_237113_((String)" [");
        players.forEach(player -> {
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null) {
                current.kick((Player)player);
                if (inform) {
                    MutableComponent message = Component.m_237110_((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.m_213846_((Component)message);
                }
                TeamCommand.notifyTeam(source.m_81377_(), current.getMembers(), player, false);
                if (counter.get() > 0) {
                    names.m_130946_(", ");
                }
                counter.getAndIncrement();
                names.m_7220_(player.m_5446_());
            }
        });
        if (counter.get() > 0) {
            names.m_130946_("]");
            source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_KICK_SUCCESS, (Object[])new Object[]{counter.get()}).m_7220_((Component)names), true);
        }
        return 0;
    }

    private static int sysadmin_add(CommandSourceStack source, String teamId, Collection<ServerPlayer> players, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            AtomicInteger counter = new AtomicInteger();
            MutableComponent names = Component.m_237113_((String)" [");
            players.forEach(player -> {
                MutableComponent message;
                PlayerTeam current = TeamHelper.getTeam((Player)player);
                if (current != null && force) {
                    current.kick((Player)player);
                    message = Component.m_237110_((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.m_213846_((Component)message);
                    TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), player, false);
                    current = null;
                }
                if (current == null) {
                    TeamCommand.notifyTeam(source.m_81377_(), team.getMembers(), player, true);
                    team.add((Player)player);
                    message = Component.m_237110_((String)SYSADMIN_ADDED_TO_TEAM, (Object[])new Object[]{team.getDisplayName()});
                    player.m_213846_((Component)message);
                    if (counter.get() > 0) {
                        names.m_130946_(", ");
                    }
                    counter.getAndIncrement();
                    names.m_7220_(player.m_5446_());
                }
            });
            if (counter.get() > 0) {
                names.m_130946_("]");
                source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_ADD_SUCCESS, (Object[])new Object[]{counter.get(), teamId}).m_7220_((Component)names), true);
            }
        } else {
            source.m_81352_(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_transfer(CommandSourceStack source, String teamId, ServerPlayer player, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            MutableComponent message;
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null && force) {
                current.kick((Player)player);
                message = Component.m_237110_((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                player.m_213846_((Component)message);
                current = null;
            }
            if (current == null) {
                if (team.transfer((Player)player)) {
                    message = Component.m_237110_((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{team.getDisplayName()});
                    player.m_213846_((Component)message);
                    source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_TRANSFER_SUCCESS, (Object[])new Object[]{teamId, player.m_5446_()}), true);
                } else {
                    source.m_81352_(TRANSFER_FAIL_SAME);
                }
            }
        } else {
            source.m_81352_(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_disband(CommandSourceStack source, String teamId) {
        if (TeamHelper.doesTeamExist(teamId)) {
            MutableComponent message = Component.m_237110_((String)SYSADMIN_TEAM_DISBANDED, (Object[])new Object[]{TeamHelper.getTeamDisplayName(teamId)});
            List<UUID> players = TeamHelper.deleteTeam(teamId);
            source.m_81377_().m_6846_().m_11314_().forEach(serverPlayer -> {
                UUID uuid = serverPlayer.m_20148_();
                if (players.contains(uuid)) {
                    serverPlayer.m_213846_((Component)message);
                }
            });
            source.m_288197_(() -> Component.m_237110_((String)SYSADMIN_DISBAND_SUCCESS, (Object[])new Object[]{teamId}), true);
        } else {
            source.m_81352_(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int teamMessage(CommandSourceStack source, Component message) {
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerTeam team = TeamHelper.getTeam((Player)player);
            if (team != null) {
                String rank = player.m_20148_().equals(team.getLeader()) ? RANK_LEADER : (team.isManager(player.m_20148_()) ? RANK_MANAGER : "");
                MutableComponent textComponent = Component.m_237113_((String)("\u00a7a[team]\u00a7r " + rank)).m_7220_(player.m_5446_()).m_130946_("\u00a7a:\u00a7r ").m_7220_(message);
                List<UUID> members = team.getMembers();
                source.m_81377_().m_6846_().m_11314_().forEach(arg_0 -> TeamCommand.lambda$teamMessage$49(members, (Component)textComponent, arg_0));
            } else {
                source.m_81352_(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static /* synthetic */ void lambda$teamMessage$49(List members, Component textComponent, ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.m_20148_();
        if (members.contains(uuid)) {
            serverPlayer.m_213846_(textComponent);
        }
    }

    public static class TeamArgument
    implements ArgumentType<String> {
        public static String get(CommandContext<CommandSourceStack> context, String key) {
            return (String)context.getArgument(key, String.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82970_(TeamHelper.getTeams(), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }
}

