/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class PacketTeamSync
extends PacketBase {
    private final String teamId;
    private final String teamName;
    private final Byte status;

    public PacketTeamSync(PlayerTeam team, Player player) {
        this(team == null ? "$nil" : team.getId(), team == null ? "$nil" : Component.Serializer.m_130703_((Component)team.getDisplayName()), team == null || player == null ? (byte)-1 : team.getPlayerStatus(player));
    }

    private PacketTeamSync(String teamId, String teamName, Byte status) {
        this.teamId = teamId;
        this.teamName = teamName;
        this.status = status;
    }

    public static void writeData(PacketTeamSync packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.teamId);
        buffer.m_130070_(packet.teamName);
        buffer.writeByte((int)packet.status.byteValue());
    }

    public static PacketTeamSync readData(FriendlyByteBuf buffer) {
        return new PacketTeamSync(buffer.m_130277_(), buffer.m_130277_(), buffer.readByte());
    }

    @Override
    public void handleClientSide(Player player) {
        UUID uuid = player.m_20148_();
        if (this.status > 0) {
            PlayerTeam team = TeamHelper.getTeam(this.teamId);
            if (team == null) {
                team = PlayerTeam.create(this.teamId, null, (Component)Component.Serializer.m_130701_((String)this.teamName));
            }
            team.setPlayerStatus(this.status, uuid);
        } else {
            PlayerTeam team = TeamHelper.PLAYER_TEAM.get(uuid);
            if (this.teamId.equals("$nil") || team != null && this.teamId.equals(team.getId())) {
                TeamHelper.PLAYER_TEAM.remove(uuid);
            }
            TeamHelper.SAVEDATA.TEAMS.remove(this.teamId);
        }
    }

    @Override
    public void handleServerSide(Player player) {
    }
}

