/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.adapter;

import dev.toma.configuration.config.adapter.AdapterHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAttributes;
import dev.toma.configuration.config.adapter.TypeMapper;
import dev.toma.configuration.config.adapter.TypeMappers;
import dev.toma.configuration.config.adapter.TypeMatcher;
import dev.toma.configuration.config.value.BooleanArrayValue;
import dev.toma.configuration.config.value.BooleanValue;
import dev.toma.configuration.config.value.ByteArrayValue;
import dev.toma.configuration.config.value.ByteValue;
import dev.toma.configuration.config.value.CharArrayValue;
import dev.toma.configuration.config.value.CharValue;
import dev.toma.configuration.config.value.DoubleArrayValue;
import dev.toma.configuration.config.value.DoubleValue;
import dev.toma.configuration.config.value.EnumArrayValue;
import dev.toma.configuration.config.value.EnumValue;
import dev.toma.configuration.config.value.FloatArrayValue;
import dev.toma.configuration.config.value.FloatValue;
import dev.toma.configuration.config.value.IntArrayValue;
import dev.toma.configuration.config.value.IntValue;
import dev.toma.configuration.config.value.LongArrayValue;
import dev.toma.configuration.config.value.LongValue;
import dev.toma.configuration.config.value.ObjectValue;
import dev.toma.configuration.config.value.ShortArrayValue;
import dev.toma.configuration.config.value.ShortValue;
import dev.toma.configuration.config.value.StringArrayValue;
import dev.toma.configuration.config.value.StringValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TypeAdapterManager {
    private static final Map<Class<?>, TypeMapper<?, ?>> TYPE_MAPPERS = new HashMap();
    private static final Set<AdapterHolder<TypeAdapter<?>>> ADAPTERS = new HashSet();

    public static <T> TypeAttributes<T> forType(Class<T> type) {
        TypeAdapter adapter = ADAPTERS.stream().filter(entry -> entry.test(type)).sorted().map(AdapterHolder::adapter).findFirst().orElse(null);
        TypeMapper<T, Object> mapper = TypeAdapterManager.getTypeMapper(type);
        return new TypeAttributes<T>(adapter, mapper);
    }

    public static <T> TypeMapper<T, Object> getTypeMapper(Class<T> type) {
        return TYPE_MAPPERS.getOrDefault(type, TypeMapper.identity());
    }

    public static <T> void registerTypeMapper(Class<T> type, TypeMapper<T, ?> mapper) {
        TYPE_MAPPERS.put(type, mapper);
    }

    public static void registerTypeAdapter(TypeMatcher matcher, TypeAdapter<?> adapter) {
        if (!ADAPTERS.add(new AdapterHolder(matcher, adapter))) {
            throw new IllegalArgumentException("Duplicate type matcher with id: " + matcher.getIdentifier());
        }
    }

    static {
        TypeAdapterManager.registerTypeMapper(boolean[].class, TypeMappers.boolArrayRemapper());
        TypeAdapterManager.registerTypeMapper(byte[].class, TypeMappers.byteArrayRemapper());
        TypeAdapterManager.registerTypeMapper(char[].class, TypeMappers.charArrayRemapper());
        TypeAdapterManager.registerTypeMapper(short[].class, TypeMappers.shortArrayRemapper());
        TypeAdapterManager.registerTypeMapper(int[].class, TypeMappers.intArrayRemapper());
        TypeAdapterManager.registerTypeMapper(long[].class, TypeMappers.longArrayRemapper());
        TypeAdapterManager.registerTypeMapper(float[].class, TypeMappers.floatArrayRemapper());
        TypeAdapterManager.registerTypeMapper(double[].class, TypeMappers.doubleArrayRemapper());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchBoolean(), new BooleanValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchCharacter(), new CharValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchByte(), new ByteValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchShort(), new ShortValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchInteger(), new IntValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchLong(), new LongValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchFloat(), new FloatValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchDouble(), new DoubleValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchString(), new StringValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchBooleanArray(), new BooleanArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchCharacterArray(), new CharArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchByteArray(), new ByteArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchShortArray(), new ShortArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchIntegerArray(), new IntArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchLongArray(), new LongArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchFloatArray(), new FloatArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchDoubleArray(), new DoubleArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchStringArray(), new StringArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchEnum(), new EnumValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchEnumArray(), new EnumArrayValue.Adapter());
        TypeAdapterManager.registerTypeAdapter(TypeMatcher.matchObject(), new ObjectValue.Adapter());
    }
}

