/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class ConfigSaveCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = new ConfigSuggestionProvider();
    private static final SimpleCommandExceptionType NOT_ENOUGH_ARGUMENTS = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"text.configuration.command.not_enough_arguments"));
    private static final DynamicCommandExceptionType UNKNOWN_CONFIG = new DynamicCommandExceptionType(t -> Component.m_237110_((String)"text.configuration.command.unknown_config", (Object[])new Object[]{t}));
    private static final Component TEXT_CONFIGS_SAVED = Component.m_237115_((String)"text.configuration.command.configs_saved").m_130940_(ChatFormatting.GREEN);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"configuration").requires(stack -> stack.m_6761_(2))).executes(stack -> {
            throw NOT_ENOUGH_ARGUMENTS.create();
        })).then(Commands.m_82127_((String)"saveAll").executes(context -> ConfigSaveCommand.saveConfig((CommandContext<CommandSourceStack>)context, true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"save").executes(stack -> {
            throw NOT_ENOUGH_ARGUMENTS.create();
        })).then(Commands.m_82129_((String)"configId", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGESTION_PROVIDER).executes(context -> ConfigSaveCommand.saveConfig((CommandContext<CommandSourceStack>)context, false)))));
    }

    private static int saveConfig(CommandContext<CommandSourceStack> ctx, boolean isSaveAll) throws CommandSyntaxException {
        ArrayList<String> configsForUpdate = isSaveAll ? new ArrayList<String>(ConfigHolder.getRegisteredConfigs()) : Collections.singletonList((String)ctx.getArgument("configId", String.class));
        for (String configId : configsForUpdate) {
            ConfigHolder holder = Configuration.getConfig(configId).orElseThrow(() -> UNKNOWN_CONFIG.create((Object)configId));
            holder.save();
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> TEXT_CONFIGS_SAVED, true);
        return 0;
    }

    private static class ConfigSuggestionProvider
    implements SuggestionProvider<CommandSourceStack> {
        private ConfigSuggestionProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            Collection<String> configs = ConfigHolder.getRegisteredConfigs();
            configs.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }
}

