/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapterManager;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ArrayConfigScreen<V, C extends AbstractArrayValue<V>>
extends AbstractConfigScreen {
    public static final Component ADD_ELEMENT = Component.m_237115_((String)"text.configuration.value.add_element");
    public static final ResourceLocation REMOVE_ICON = new ResourceLocation("configuration", "textures/icons/remove.png");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V[]> removeHandler;

    public ArrayConfigScreen(ConfigHolder<?> holder, C array, Screen previous) {
        super(((ConfigValue)array).getValueData().getTitle(), previous, holder);
        this.array = array;
        this.fixedSize = ((AbstractArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V[]> handler) {
        this.removeHandler = handler;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.getTotalSize());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        Class<?> compType = ((Object[])this.array.get()).getClass().getComponentType();
        DisplayAdapter adapter = this.theme.getAdapter(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) {
                if (this.fixedSize) break;
                ThemedButtonWidget addElement = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(30, 45 + j * spacing + offset, this.f_96543_ - 60, 20, ADD_ELEMENT, this.theme));
                addElement.setBackgroundRenderer(this.theme.getButtonBackground(addElement));
                addElement.setClickListener((widget, mouseX, mouseY) -> {
                    this.addHandler.insertElement();
                    this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                });
                break;
            }
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processFieldData(owner);
            Component label = this.getEntryLabel(dummy, i);
            ConfigEntryWidget widget2 = (ConfigEntryWidget)this.m_142416_((GuiEventListener)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.f_96543_ - 60, 20, label, dummy, this.getConfigId(), this.theme));
            widget2.setDescriptionRenderer(this);
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, dummy, owner, this.theme, widget2);
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)compType.getSimpleName()), (Throwable)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            ThemedButtonWidget removeButton = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(this.f_96543_ - 29, widget2.m_252907_(), 20, 20, CommonComponents.f_237098_, this.theme));
            removeButton.setClickListener((widget1, mouseX, mouseY) -> {
                this.removeHandler.removeElementAt(elementIndex, (index1, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, this.index);
                    System.arraycopy(src, this.index + 1, dest, this.index, this.sizeSupplier.get() - 1 - this.index);
                    return dest;
                });
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            });
            removeButton.setBackgroundRenderer(this.theme.getButtonBackground(removeButton));
            removeButton.setForegroundRenderer(new TextureRenderer(REMOVE_ICON, 2, 2, 16, 16));
        }
        this.addSettingsButton();
        this.addFooter();
    }

    private <T> Component getEntryLabel(ConfigValue<T> value, int index) {
        ValueData<T> valueData = value.getValueData();
        String languageKey = valueData.getLanguageKey(valueData.getAttributes()) + ".entry";
        MutableComponent translated = Component.m_237115_((String)languageKey);
        return Component.m_237113_((String)("[" + index + "] " + translated.getString()));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        ConfigTheme.Header themeHeader = this.theme.getHeader();
        ConfigTheme.Footer footer = this.theme.getFooter();
        Component headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.f_96539_;
        int titleWidth = this.f_96547_.m_92852_((FormattedText)headerLabel);
        int n = (this.f_96543_ - titleWidth) / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280430_(this.f_96547_, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor());
        graphics.m_280509_(0, 0, this.f_96543_, 35, themeHeader.backgroundColor());
        graphics.m_280509_(0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, footer.backgroundColor());
        Integer fillColor = this.theme.getBackgroundFillColor();
        if (fillColor != null) {
            graphics.m_280509_(0, 35, this.f_96543_, this.f_96544_ - 30, fillColor.intValue());
        }
        this.f_169369_.forEach(renderable -> renderable.m_88315_(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ArrayConfigScreen.renderScrollbar(graphics, this.f_96543_ - scrollbar.width(), 35, scrollbar.width(), this.f_96544_ - 30 - 35, this.index, this.getTotalSize(), this.pageSize, scrollbar.backgroundColor());
    }

    public boolean m_6050_(double mouseX, double mouseY, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.getTotalSize()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    private int getTotalSize() {
        int elementSize = this.sizeSupplier.get();
        if (!this.fixedSize) {
            ++elementSize;
        }
        return elementSize;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter<?> typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapterManager.forType(type).adapter();
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter<?> getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }

        @Override
        public void setValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }
}

