/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.net;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.zeith.hammerlib.api.lighting.ColoredLightManager;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.solarflux.block.SolarPanelTile;

public class PacketRequestSolarIntensity
implements IPacket {
    protected BlockPos pos;
    protected float sunIntensity;

    public PacketRequestSolarIntensity() {
    }

    public PacketRequestSolarIntensity(BlockPos pos, float sunIntensity) {
        this.pos = pos;
        this.sunIntensity = sunIntensity;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).writeFloat(this.sunIntensity);
    }

    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.sunIntensity = buf.readFloat();
    }

    public void serverExecute(PacketContext ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_284548_();
        BlockState bs = level.m_8055_(this.pos);
        BlockEntity be = level.getExistingBlockEntity(this.pos);
        SolarPanelTile spt = (SolarPanelTile)Cast.cast((Object)be, SolarPanelTile.class);
        if (spt == null) {
            return;
        }
        this.sunIntensity = spt.sunIntensity;
        ctx.withReply((IPacket)this);
    }

    public void clientExecute(PacketContext ctx) {
        Player player = ColoredLightManager.getClientPlayer();
        if (player == null) {
            return;
        }
        SolarPanelTile spt = (SolarPanelTile)Cast.cast((Object)player.m_9236_().m_7702_(this.pos), SolarPanelTile.class);
        if (spt == null) {
            return;
        }
        spt.sunIntensity = this.sunIntensity;
    }
}

