/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UV {
    public static final String U = "u";
    public static final String V = "v";
    @Nullable
    private PhaseHandler phaseHandler;
    private final float u;
    private final float v;
    public static final Codec<UV> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf(U).forGetter(UV::u), (App)Codec.FLOAT.fieldOf(V).forGetter(UV::v)).apply((Applicative)instance, UV::new));

    public UV(@Nullable PhaseHandler phaseHandler, float u, float v) {
        if (phaseHandler != null && phaseHandler.doPhases()) {
            this.phaseHandler = phaseHandler;
        }
        this.u = u;
        this.v = v;
    }

    public UV(float u, float v) {
        this(null, u, v);
    }

    public float u() {
        return this.u;
    }

    public float u(long ticks) {
        return this.phaseHandler != null ? (this.u + (float)this.phaseHandler.u(ticks)) / (float)this.phaseHandler.columns() : this.u;
    }

    public float v() {
        return this.v;
    }

    public float v(long ticks) {
        return this.phaseHandler != null ? (this.v + (float)this.phaseHandler.v(ticks)) / (float)this.phaseHandler.rows() : this.v;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_(U, this.u);
        tag.m_128350_(V, this.v);
        return tag;
    }

    public static UV deserialize(CompoundTag tag, PhaseHandler phaseHandler) {
        return new UV(phaseHandler, tag.m_128457_(U), tag.m_128457_(V));
    }

    public static class PhaseHandler {
        public static final String TICKS_PER_PHASE = "ticks_per_phase";
        public static final String PHASE_TICK_OFFSET = "phase_tick_offset";
        public static final String COLUMNS = "columns";
        public static final String ROWS = "rows";
        private final int ticksPerPhase;
        private final int phaseTickOffset;
        private final int columns;
        private final int rows;
        private final int totalPhases;
        private final int tickPeriod;
        private final boolean doPhases;
        public static final PhaseHandler DEFAULT_PHASE_HANDLER = new PhaseHandler(24000, 0, 1, 1);
        public static final Codec<PhaseHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(TICKS_PER_PHASE).forGetter(phaseHandler -> phaseHandler.ticksPerPhase), (App)Codec.INT.optionalFieldOf(PHASE_TICK_OFFSET, (Object)0).forGetter(phaseHandler -> phaseHandler.phaseTickOffset), (App)Codec.INT.fieldOf(COLUMNS).forGetter(phaseHandler -> phaseHandler.columns), (App)Codec.INT.fieldOf(ROWS).forGetter(phaseHandler -> phaseHandler.rows)).apply((Applicative)instance, PhaseHandler::new));

        public PhaseHandler(int ticksPerPhase, int phaseTickOffset, int columns, int rows) {
            this.ticksPerPhase = ticksPerPhase;
            this.phaseTickOffset = phaseTickOffset;
            this.columns = columns;
            this.rows = rows;
            this.totalPhases = columns * rows;
            this.tickPeriod = ticksPerPhase * this.totalPhases;
            this.doPhases = this.totalPhases != 1;
        }

        public int phase(long ticks) {
            return (int)((ticks + (long)this.phaseTickOffset) % (long)this.tickPeriod * (long)this.totalPhases) / this.tickPeriod;
        }

        public int u(long ticks) {
            return this.phase(ticks) % this.columns;
        }

        public int v(long ticks) {
            return this.phase(ticks) / this.columns % this.rows;
        }

        public int rows() {
            return this.rows;
        }

        public int columns() {
            return this.columns;
        }

        public boolean doPhases() {
            return this.doPhases;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(TICKS_PER_PHASE, this.ticksPerPhase);
            tag.m_128405_(PHASE_TICK_OFFSET, this.phaseTickOffset);
            tag.m_128405_(COLUMNS, this.columns);
            tag.m_128405_(ROWS, this.rows);
            return tag;
        }

        public static PhaseHandler deserialize(CompoundTag tag) {
            return new PhaseHandler(tag.m_128451_(TICKS_PER_PHASE), tag.m_128451_(PHASE_TICK_OFFSET), tag.m_128451_(COLUMNS), tag.m_128451_(ROWS));
        }
    }

    public static class Quad {
        public static final String PHASE_HANDLER = "phase_handler";
        public static final String TOP_LEFT = "top_left";
        public static final String BOTTOM_LEFT = "bottom_left";
        public static final String BOTTOM_RIGHT = "bottom_right";
        public static final String TOP_RIGHT = "top_right";
        public static final String FLIP_UV = "flip_uv";
        public static final Quad DEFAULT_QUAD_UV = new Quad(false);
        private final PhaseHandler phaseHandler;
        private final UV topLeft;
        private final UV bottomLeft;
        private final UV bottomRight;
        private final UV topRight;
        private final boolean flipped;
        public static final Codec<Quad> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PhaseHandler.CODEC.optionalFieldOf(PHASE_HANDLER, (Object)PhaseHandler.DEFAULT_PHASE_HANDLER).forGetter(quad -> quad.phaseHandler), (App)Codec.FLOAT.optionalFieldOf("u_start", (Object)Float.valueOf(0.0f)).forGetter(quad -> Float.valueOf(quad.topLeft.u())), (App)Codec.FLOAT.optionalFieldOf("v_start", (Object)Float.valueOf(0.0f)).forGetter(quad -> Float.valueOf(quad.topLeft.v())), (App)Codec.FLOAT.optionalFieldOf("u_end", (Object)Float.valueOf(1.0f)).forGetter(quad -> Float.valueOf(quad.bottomRight.u())), (App)Codec.FLOAT.optionalFieldOf("v_end", (Object)Float.valueOf(1.0f)).forGetter(quad -> Float.valueOf(quad.bottomRight.v())), (App)Codec.INT.optionalFieldOf("rotation", (Object)0).forGetter(quad -> 0), (App)Codec.BOOL.optionalFieldOf(FLIP_UV, (Object)false).forGetter(quad -> quad.flipped)).apply((Applicative)instance, Quad::new));

        public Quad(PhaseHandler phaseHandler, UV topLeft, UV bottomLeft, UV bottomRight, UV topRight, Rotation rotation, boolean flipped) {
            UV[] uv = new UV[]{topLeft, bottomLeft, bottomRight, topRight};
            this.phaseHandler = phaseHandler;
            if (flipped) {
                this.topLeft = rotation.shiftUV(uv, 3);
                this.bottomLeft = rotation.shiftUV(uv, 2);
                this.bottomRight = rotation.shiftUV(uv, 1);
                this.topRight = rotation.shiftUV(uv, 0);
            } else {
                this.topLeft = rotation.shiftUV(uv, 0);
                this.bottomLeft = rotation.shiftUV(uv, 1);
                this.bottomRight = rotation.shiftUV(uv, 2);
                this.topRight = rotation.shiftUV(uv, 3);
            }
            this.flipped = flipped;
        }

        public Quad(PhaseHandler phaseHandler, UV topLeft, UV bottomLeft, UV bottomRight, UV topRight) {
            this(phaseHandler, topLeft, bottomLeft, bottomRight, topRight, Rotation.DEG_0, false);
        }

        public Quad(PhaseHandler phaseHandler, float topLeftU, float topLeftV, float bottomRightU, float bottomRightV, int rotation, boolean flipped) {
            this(phaseHandler, new UV(phaseHandler, topLeftU, topLeftV), new UV(phaseHandler, topLeftU, bottomRightV), new UV(phaseHandler, bottomRightU, bottomRightV), new UV(phaseHandler, bottomRightU, topLeftV), Rotation.rotationFromInt(rotation), flipped);
        }

        public Quad(PhaseHandler phaseHandler, float topLeftU, float topLeftV, float bottomRightU, float bottomRightV, int rotation) {
            this(phaseHandler, topLeftU, topLeftV, bottomRightU, bottomRightV, rotation, false);
        }

        public Quad(PhaseHandler phaseHandler, boolean flipped) {
            this(phaseHandler, 0.0f, 0.0f, 1.0f, 1.0f, 0, flipped);
        }

        public Quad(boolean flipped) {
            this(PhaseHandler.DEFAULT_PHASE_HANDLER, new UV(0.0f, 0.0f), new UV(0.0f, 1.0f), new UV(1.0f, 1.0f), new UV(1.0f, 0.0f), Rotation.DEG_0, flipped);
        }

        public UV topLeft() {
            return this.topLeft;
        }

        public UV bottomLeft() {
            return this.bottomLeft;
        }

        public UV bottomRight() {
            return this.bottomRight;
        }

        public UV topRight() {
            return this.topRight;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(PHASE_HANDLER, (Tag)this.phaseHandler.serialize());
            tag.m_128365_(TOP_LEFT, (Tag)this.topLeft.serialize());
            tag.m_128365_(BOTTOM_LEFT, (Tag)this.bottomLeft.serialize());
            tag.m_128365_(BOTTOM_RIGHT, (Tag)this.bottomRight.serialize());
            tag.m_128365_(TOP_RIGHT, (Tag)this.topRight.serialize());
            tag.m_128379_(FLIP_UV, this.flipped);
            return tag;
        }

        public static Quad deserialize(CompoundTag tag) {
            PhaseHandler phaseHandler = PhaseHandler.deserialize(tag.m_128469_(PHASE_HANDLER));
            return new Quad(phaseHandler, UV.deserialize(tag.m_128469_(TOP_LEFT), phaseHandler), UV.deserialize(tag.m_128469_(BOTTOM_LEFT), phaseHandler), UV.deserialize(tag.m_128469_(BOTTOM_RIGHT), phaseHandler), UV.deserialize(tag.m_128469_(TOP_RIGHT), phaseHandler));
        }
    }

    public static enum Rotation {
        DEG_0,
        DEG_90,
        DEG_180,
        DEG_270;


        public UV shiftUV(UV[] uv, int i) {
            return uv[(i + this.ordinal()) % uv.length];
        }

        public static Rotation rotationFromInt(int rotation) throws IllegalArgumentException {
            switch (rotation) {
                case 0: {
                    return DEG_0;
                }
                case -270: 
                case 90: {
                    return DEG_90;
                }
                case -180: 
                case 180: {
                    return DEG_180;
                }
                case -90: 
                case 270: {
                    return DEG_270;
                }
            }
            throw new IllegalArgumentException("Invalid rotation value: " + rotation + ", must be one of {0, 90, 180, 270, -90}");
        }

        public static Rotation rotationFromUV(float topLeftU, float topLeftV, float bottomRightU, float bottomRightV) {
            if (topLeftU <= bottomRightU) {
                return topLeftV <= bottomRightV ? DEG_0 : DEG_90;
            }
            return topLeftV <= bottomRightV ? DEG_180 : DEG_270;
        }
    }
}

