/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.LevelData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WorldUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isSingleplayer() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91091_() && Minecraft.m_91087_().m_91092_() != null && !Minecraft.m_91087_().m_91092_().m_6992_();
    }

    public static boolean isMultiplayer() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        return !WorldUtils.isSingleplayer();
    }

    @NotNull
    public static List<LevelSummary> getLevels() {
        LevelStorageSource.LevelCandidates levelCandidates;
        Minecraft minecraft = Minecraft.m_91087_();
        try {
            levelCandidates = minecraft.m_91392_().m_230833_();
        }
        catch (LevelStorageException ex) {
            LOGGER.error("[FANCYMENU] Couldn't load level list!", (Throwable)ex);
            return List.of();
        }
        if (levelCandidates.m_230843_()) {
            return List.of();
        }
        CompletionStage future = minecraft.m_91392_().m_230813_(levelCandidates).exceptionally(throwable -> List.of());
        try {
            return Objects.requireNonNullElse(((CompletableFuture)future).getNow(List.of()), List.of());
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    @NotNull
    public static List<LevelData> getLevelsAsData() {
        ArrayList<LevelData> data = new ArrayList<LevelData>();
        WorldUtils.getLevels().forEach(summary -> data.add(LevelData.fromLevelSummary(summary)));
        return data;
    }
}

