/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.content.blocks.NubBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.util.IBlockSetBase;
import architectspalette.core.registry.util.RegistryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;

public class StoneBlockSet
implements Supplier<Block> {
    private final String material_name;
    private final List<RegistryObject<? extends Block>> parts;
    public TagKey<Block> miningTag = BlockTags.f_144282_;
    public TagKey<Block> miningLevel = null;
    public boolean hasStoneCuttingRecipes = true;
    private static final List<StoneBlockSet> instances = new LinkedList<StoneBlockSet>();

    public static void forAllSets(Consumer<StoneBlockSet> consumer) {
        instances.forEach(consumer);
    }

    public StoneBlockSet(RegistryObject<? extends Block> base_block) {
        this(base_block, SetGroup.TYPICAL);
    }

    public StoneBlockSet(RegistryObject<? extends Block> base_block, SetGroup group) {
        this(base_block, group.components);
    }

    public StoneBlockSet(RegistryObject<? extends Block> base_block, SetGroup group, SetComponent ... additionalParts) {
        this(base_block, StoneBlockSet.concatArray(group.components, additionalParts));
    }

    public StoneBlockSet(RegistryObject<? extends Block> base_block, SetComponent ... parts) {
        this.parts = new ArrayList<RegistryObject<? extends Block>>();
        for (int i = 0; i < SetComponent.values().length; ++i) {
            this.parts.add(null);
        }
        this.material_name = StoneBlockSet.getMaterialFromBlock(base_block.getId().m_135815_());
        this.setPart(SetComponent.BLOCK, base_block);
        for (SetComponent part : parts) {
            this.createPart(part);
        }
        instances.add(this);
    }

    private static String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile").replace("boards", "board");
    }

    private static String getMaterialAggressive(String block) {
        return StoneBlockSet.getMaterialFromBlock(block).replace("_brick", "").replace("_tile", "").replace("chiseled_", "");
    }

    private BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getPart(SetComponent.BLOCK));
    }

    @Override
    public Block get() {
        return this.getPart(SetComponent.BLOCK);
    }

    private Stream<? extends Block> blockStream() {
        return this.parts.stream().filter(Objects::nonNull).map(RegistryObject::get);
    }

    private Stream<RegistryObject<? extends Block>> registryObjectStream() {
        return this.parts.stream().filter(Objects::nonNull);
    }

    public void forEach(Consumer<? super Block> action) {
        this.blockStream().forEach(action);
    }

    public void forEachRegistryObject(Consumer<RegistryObject<? extends Block>> action) {
        this.registryObjectStream().forEach(action);
    }

    public void forEachPart(BiConsumer<SetComponent, ? super Block> consumer) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.get(i) == null) continue;
            consumer.accept(SetComponent.get(i), (Block)this.parts.get(i).get());
        }
    }

    public void registerFlammable(int encouragement, int flammability) {
        this.forEach(b -> APBlockProperties.registerFlammable(b, encouragement, flammability));
    }

    public StoneBlockSet woodify() {
        this.usesAxe();
        this.hasStoneCuttingRecipes = false;
        return this;
    }

    public StoneBlockSet usesAxe() {
        this.miningTag = BlockTags.f_144280_;
        return this;
    }

    public StoneBlockSet needsStone() {
        this.miningLevel = BlockTags.f_144286_;
        return this;
    }

    public StoneBlockSet needsIron() {
        this.miningLevel = BlockTags.f_144285_;
        return this;
    }

    public StoneBlockSet needsDiamond() {
        this.miningLevel = BlockTags.f_144284_;
        return this;
    }

    public Block getPart(SetComponent part) {
        return (Block)this.parts.get(part.ordinal()).get();
    }

    public RegistryObject<? extends Block> getRegistryPart(SetComponent part) {
        return this.parts.get(part.ordinal());
    }

    private void setPart(SetComponent part, RegistryObject<? extends Block> block) {
        this.parts.add(part.ordinal(), block);
    }

    private void createPart(SetComponent part) {
        this.setPart(part, this.makePart(part));
    }

    public void withPart(SetComponent part, Consumer<Block> action) {
        Block block = this.getPart(part);
        if (block != null) {
            action.accept(block);
        }
    }

    private RegistryObject<Block> makePart(SetComponent part) {
        return RegistryUtils.createBlock(part.getName(this.material_name), () -> {
            Block block = this.getPart(SetComponent.BLOCK);
            if (block instanceof IBlockSetBase) {
                IBlockSetBase base = (IBlockSetBase)block;
                return base.getBlockForPart(part, this.properties(), block);
            }
            return StoneBlockSet.getBlockForPart(part, this.properties(), block);
        }, part.tab);
    }

    public static Block getBlockForPart(SetComponent part, BlockBehaviour.Properties properties, Block base) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case SetComponent.WALL -> new WallBlock(properties);
            case SetComponent.SLAB -> new SlabBlock(properties);
            case SetComponent.VERTICAL_SLAB -> new VerticalSlabBlock(properties);
            case SetComponent.STAIRS -> new StairBlock(() -> ((Block)base).m_49966_(), properties);
            case SetComponent.FENCE -> new FenceBlock(properties);
            case SetComponent.PILLAR -> new RotatedPillarBlock(properties);
            case SetComponent.NUB -> new NubBlock(properties);
            case SetComponent.BLOCK -> throw new IllegalStateException("Should not call makePart on BLOCK. Use setPart instead.");
        };
    }

    private static <T> T[] concatArray(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static enum SetGroup {
        SLABS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB),
        NO_WALLS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS),
        NO_STAIRS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.WALL),
        TYPICAL(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS, SetComponent.WALL);

        public final SetComponent[] components;

        private SetGroup(SetComponent ... components) {
            this.components = components;
        }

        public void forEach(Consumer<SetComponent> action) {
            Arrays.stream(this.components).forEachOrdered(action);
        }
    }

    public static enum SetComponent {
        BLOCK("", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        SLAB("_slab", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        VERTICAL_SLAB("_vertical_slab", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        STAIRS("_stairs", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        WALL("_wall", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        FENCE("_fence", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        PILLAR(SetComponent::pillarName, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_),
        NUB("_nub", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);

        public final ResourceKey<CreativeModeTab> tab;
        public final Function<String, String> nameGenerator;
        private static final SetComponent[] values;

        private SetComponent(String suffix, ResourceKey<CreativeModeTab> tab) {
            this((String material) -> SetComponent.addSuffix(material, suffix), tab);
        }

        private SetComponent(Function<String, String> nameGen, ResourceKey<CreativeModeTab> tab) {
            this.nameGenerator = nameGen;
            this.tab = tab;
        }

        public String getName(String material) {
            return this.nameGenerator.apply(material);
        }

        private static String addSuffix(String material, String suffix) {
            return material + suffix;
        }

        private static String pillarName(String material) {
            return StoneBlockSet.getMaterialAggressive(material) + "_pillar";
        }

        public static SetComponent get(int ordinal) {
            return values[ordinal];
        }

        static {
            values = SetComponent.values();
        }
    }
}

