/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.content.blocks.BreadBlock;
import architectspalette.content.blocks.NubBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.content.blocks.util.DirectionalFacingBlock;
import architectspalette.core.ArchitectsPalette;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.util.BlockNode;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Blockstates
extends BlockStateProvider {
    private final BlockModelProvider awesomeBlockModels;
    private static BlockNode currentNode;
    private final ExistingFileHelper fileHelper;
    private static final ResourceLocation dummy;
    private static ResourceLocation currentModelName;
    protected static final ExistingFileHelper.ResourceType TEXTURE;

    public Blockstates(PackOutput gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.fileHelper = exFileHelper;
        this.awesomeBlockModels = new BlockModelProvider(gen, modid, exFileHelper){

            public CompletableFuture<?> m_213708_(CachedOutput cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }

            protected void registerModels() {
            }

            public BlockModelBuilder getBuilder(String path) {
                Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
                ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path));
                this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
                BlockModelBuilder present = (BlockModelBuilder)this.generatedModels.get(outputLoc);
                if (present == null) {
                    BlockModelBuilder builder = (BlockModelBuilder)this.factory.apply(outputLoc);
                    this.generatedModels.put(outputLoc, builder);
                    BlockModelBuilder replacement = Blockstates.this.onNewModel(builder);
                    if (replacement != null) {
                        return replacement;
                    }
                    return builder;
                }
                return present;
            }

            public BlockModelBuilder nested() {
                return (BlockModelBuilder)this.factory.apply(currentModelName);
            }

            private ResourceLocation extendWithFolder(ResourceLocation rl) {
                if (rl.m_135815_().contains("/")) {
                    return rl;
                }
                return new ResourceLocation(rl.m_135827_(), this.folder + "/" + rl.m_135815_());
            }
        };
    }

    public BlockModelProvider models() {
        return this.awesomeBlockModels;
    }

    @Nullable
    private BlockModelBuilder onNewModel(BlockModelBuilder builder) {
        BlockModelBuilder returnvalue = null;
        if (currentNode != null) {
            currentModelName = builder.getUncheckedLocation();
            if (currentNode.getDataFlag(BlockNode.DataFlag.BOARDS) && Blockstates.currentNode.type != BlockNode.BlockType.WALL) {
                returnvalue = ((WrappedModelLoaderBuilder)builder.customLoader(WrappedModelLoaderBuilder::new)).setWrapper("boards", (BlockModelBuilder)this.models().nested());
            }
            currentModelName = dummy;
        }
        return returnvalue;
    }

    protected void registerStatesAndModels() {
        for (BlockNode n : APBlocks.boards) {
            if (n.dataFlags != 0) {
                currentNode = n;
            }
            this.boardModel(n.getName(), n.get());
            currentNode = null;
        }
        this.cerebralTiles((Block)APBlocks.CEREBRAL_BLOCK.getChild(BlockNode.BlockType.TILES).get());
        this.stoneModel(APBlocks.MOONSHALE);
        BlockNode.forAllBaseNodes(this::processBlockNode);
        this.breadBlock(APBlocks.BREAD_BLOCK.get());
        this.breadSlab((Block)APBlocks.BREAD_BLOCK.getChild(BlockNode.BlockType.SLAB).get());
        this.itemModels().basicItem(APItems.ORACLE_JELLY.getId());
        this.itemModels().basicItem(APItems.CEREBRAL_PLATE.getId());
    }

    private static ResourceLocation inBlockFolder(ResourceLocation original) {
        return new ResourceLocation(original.m_135827_(), "block/" + original.m_135815_());
    }

    private static ResourceLocation inBlockFolder(ResourceLocation original, String append) {
        return new ResourceLocation(original.m_135827_(), "block/" + original.m_135815_() + append);
    }

    private static ResourceLocation inFolder(ResourceLocation original, String folder) {
        return new ResourceLocation(original.m_135827_(), folder + "/" + original.m_135815_());
    }

    private static ResourceLocation append(ResourceLocation original, String append) {
        return new ResourceLocation(original.m_135827_(), original.m_135815_() + append);
    }

    private static ResourceLocation bottom(ResourceLocation original) {
        return Blockstates.inBlockFolder(original, "_bottom");
    }

    private static ResourceLocation top(ResourceLocation original) {
        return Blockstates.inBlockFolder(original, "_top");
    }

    private static ResourceLocation side(ResourceLocation original) {
        return Blockstates.inBlockFolder(original, "_side");
    }

    private static ResourceLocation inMinecraftBlock(String name) {
        return new ResourceLocation("minecraft", "block/" + name);
    }

    private static String fileName(ResourceLocation block) {
        return "block/" + block.m_135815_();
    }

    private static ResourceLocation inAPBlockFolder(String name) {
        return Blockstates.modResourceLocation("block/" + name);
    }

    private static ResourceLocation modResourceLocation(String name) {
        return new ResourceLocation("architects_palette", name);
    }

    private static int getYRotation(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private static ModelFile blockModel(String name) {
        return new ModelFile.UncheckedModelFile(Blockstates.inAPBlockFolder(name));
    }

    private void simpleBlockstate(Block block, ModelFile model) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(model)});
    }

    private boolean textureExists(ResourceLocation location) {
        return this.fileHelper.exists(location, (ExistingFileHelper.IResourceType)TEXTURE);
    }

    private ResourceLocation getSideTexture(ResourceLocation block) {
        ResourceLocation tex = Blockstates.inBlockFolder(block, "_side");
        if (this.textureExists(tex)) {
            return tex;
        }
        return Blockstates.inBlockFolder(block);
    }

    private TextureResult getTopTexture(ResourceLocation block) {
        ResourceLocation topTex = Blockstates.inBlockFolder(block, "_top");
        boolean exists = this.textureExists(topTex);
        return new TextureResult(topTex, exists, this.getSideTexture(block));
    }

    private TextureResult getBottomTexture(ResourceLocation block) {
        ResourceLocation bottomTex = Blockstates.inBlockFolder(block, "_bottom");
        return new TextureResult(bottomTex, this.textureExists(bottomTex), this.getTopTexture((ResourceLocation)block).result);
    }

    private NodeTextures getNodeTextures(BlockNode node, Boolean checkParent) {
        ResourceLocation top = null;
        ResourceLocation side = null;
        ResourceLocation bottom = null;
        if (checkParent.booleanValue() && node.parent != null) {
            ResourceLocation n = node.getId();
            ResourceLocation p = node.parent.getId();
            switch (node.style) {
                case CUBE: {
                    side = bottom = this.findFirst(Blockstates.side(n), Blockstates.side(p), Blockstates.inBlockFolder(n), Blockstates.inBlockFolder(p));
                    top = bottom;
                    break;
                }
                case TOP_SIDES: {
                    bottom = side = this.findFirst(Blockstates.side(n), Blockstates.side(p), Blockstates.inBlockFolder(n), Blockstates.inBlockFolder(p));
                    top = this.findFirst(Blockstates.top(n), Blockstates.top(p), side);
                    break;
                }
                case TOP_SIDE_BOTTOM: {
                    side = this.findFirst(Blockstates.side(n), Blockstates.side(p), Blockstates.inBlockFolder(n), Blockstates.inBlockFolder(p));
                    top = this.findFirst(Blockstates.top(n), Blockstates.top(p), Blockstates.bottom(n), Blockstates.bottom(p), side);
                    bottom = this.findFirst(Blockstates.bottom(n), Blockstates.bottom(p), top, side);
                }
            }
        } else {
            ResourceLocation n = node.getId();
            switch (node.style) {
                case CUBE: {
                    side = bottom = this.findFirst(Blockstates.side(n), Blockstates.inBlockFolder(n));
                    top = bottom;
                    break;
                }
                case TOP_SIDES: {
                    bottom = side = this.findFirst(Blockstates.side(n), Blockstates.inBlockFolder(n));
                    top = this.findFirst(Blockstates.top(n), side);
                    break;
                }
                case TOP_SIDE_BOTTOM: {
                    side = this.findFirst(Blockstates.side(n), Blockstates.inBlockFolder(n));
                    top = this.findFirst(Blockstates.top(n), Blockstates.bottom(n), side);
                    bottom = this.findFirst(Blockstates.bottom(n), top, side);
                }
            }
        }
        return new NodeTextures(top, side, bottom);
    }

    private NodeTextures getBlockTextures(ResourceLocation n) {
        ResourceLocation side = this.findFirst(Blockstates.side(n), Blockstates.inBlockFolder(n));
        ResourceLocation top = this.findFirst(Blockstates.top(n), Blockstates.bottom(n), side);
        ResourceLocation bottom = this.findFirst(Blockstates.bottom(n), top, side);
        return new NodeTextures(top, side, bottom);
    }

    private ResourceLocation findFirst(ResourceLocation ... names) {
        for (ResourceLocation name : names) {
            if (!this.textureExists(name)) continue;
            return name;
        }
        return names[names.length - 1];
    }

    private static String getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private void verticalSlabBlock(VerticalSlabBlock block, ResourceLocation baseBlock) {
        ResourceLocation texture = Blockstates.inBlockFolder(baseBlock);
        ModelBuilder slab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Blockstates.getBlockName(block), Blockstates.inAPBlockFolder("vertical_slab"))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> this.lambda$verticalSlabBlock$0((ModelFile)slab, baseBlock, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlockItem(block, (ModelFile)slab);
    }

    private void nubModel(BlockNode node) {
        NubBlock block = (NubBlock)node.get();
        NodeTextures t = this.getBlockTextures(Blockstates.inFolder(node.getId(), "nubs"));
        ModelBuilder nub = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("nubs/" + node.getName(), Blockstates.inAPBlockFolder("nubs/parent"))).texture("bottom", t.bottom)).texture("side", t.side)).texture("top", t.top);
        ModelBuilder h_nub = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("nubs/" + node.getName() + "_horizontal", Blockstates.inAPBlockFolder("nubs/parent_horizontal"))).texture("bottom", t.bottom)).texture("side", t.side)).texture("top", t.top);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> Blockstates.lambda$nubModel$1((ModelFile)nub, (ModelFile)h_nub, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlockItem(block, (ModelFile)nub);
    }

    private void boardModel(String boardname, Block board) {
        this.simpleBlock(board);
        currentNode = null;
        ResourceLocation boardParent = Blockstates.inAPBlockFolder("boards/parent");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/boards/" + boardname + "_item", boardParent)).texture("even", Blockstates.inAPBlockFolder(boardname))).texture("odd", Blockstates.inAPBlockFolder(boardname + "_odd"));
        ((ItemModelBuilder)this.itemModels().getBuilder(boardname)).parent((ModelFile)model);
    }

    private void processBlockNode(BlockNode node) {
        if (!node.getFlag(BlockNode.ExcludeFlag.MODELS)) {
            Block block = node.get();
            String name = Blockstates.getBlockName(block);
            ResourceLocation parentTexture = node.parent != null ? Blockstates.inBlockFolder(node.parent.getId()) : Blockstates.inBlockFolder(node.getId());
            if (node.dataFlags != 0) {
                currentNode = node;
            }
            switch (node.type) {
                case NUB: {
                    this.nubModel(node);
                    break;
                }
                case SLAB: {
                    NodeTextures t = this.getNodeTextures(node, true);
                    this.slabBlock((SlabBlock)block, node.parent.getId(), t.side, t.bottom, t.top);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case VERTICAL_SLAB: {
                    this.verticalSlabBlock((VerticalSlabBlock)block, node.parent.getId());
                    break;
                }
                case STAIRS: {
                    this.stairsBlock((StairBlock)block, parentTexture);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case WALL: {
                    this.wallBlock((WallBlock)block, parentTexture);
                    BlockModelBuilder inventory = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Blockstates.fileName(node.getId()), Blockstates.inMinecraftBlock("wall_inventory"))).texture("wall", parentTexture);
                    this.simpleBlockItem(block, (ModelFile)inventory);
                    break;
                }
                case FENCE: {
                    this.fenceBlock((FenceBlock)block, parentTexture);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case PILLAR: {
                    this.logBlock((RotatedPillarBlock)block);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                default: {
                    ResourceLocation mid;
                    ResourceLocation top;
                    ResourceLocation bot = switch (node.style) {
                        default -> {
                            top = Blockstates.inBlockFolder(node.getId());
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId());
                        }
                        case BlockNode.Style.TOP_SIDES -> {
                            top = Blockstates.inBlockFolder(node.getId(), "_top");
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId(), "_top");
                        }
                        case BlockNode.Style.TOP_SIDE_BOTTOM -> {
                            top = Blockstates.inBlockFolder(node.getId(), "_top");
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId(), "_bottom");
                        }
                    };
                    String filename = Blockstates.fileName(node.getId());
                    BlockModelBuilder model = switch (node.style) {
                        default -> throw new IncompatibleClassChangeError();
                        case BlockNode.Style.CUBE -> (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_all"))).texture("all", mid);
                        case BlockNode.Style.TOP_SIDES -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_column"))).texture("end", top)).texture("side", mid);
                        case BlockNode.Style.TOP_SIDE_BOTTOM -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_bottom_top"))).texture("top", top)).texture("side", mid)).texture("bottom", bot);
                    };
                    this.simpleBlockstate(block, (ModelFile)model);
                    this.simpleBlockItem(block, (ModelFile)model);
                }
            }
            if (currentNode != null) {
                currentNode = null;
            }
        }
        for (BlockNode child : node.children) {
            this.processBlockNode(child);
        }
    }

    private void breadBlock(Block block) {
        ResourceLocation heel = Blockstates.inAPBlockFolder("bread_block_end");
        ResourceLocation inside = Blockstates.inAPBlockFolder("bread_block_inside");
        ResourceLocation whole_bottom = Blockstates.inAPBlockFolder("bread_block_bottom");
        ResourceLocation middle_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_middle");
        ResourceLocation left_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_left");
        ResourceLocation right_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_right");
        ResourceLocation whole_top = Blockstates.inAPBlockFolder("bread_block_top");
        ResourceLocation middle_top = Blockstates.inAPBlockFolder("bread_block_top_middle");
        ResourceLocation left_top = Blockstates.inAPBlockFolder("bread_block_top_left");
        ResourceLocation right_top = Blockstates.inAPBlockFolder("bread_block_top_right");
        ResourceLocation whole_side = Blockstates.inAPBlockFolder("bread_block_side");
        ResourceLocation middle_side = Blockstates.inAPBlockFolder("bread_block_side_middle");
        ResourceLocation left_side = Blockstates.inAPBlockFolder("bread_block_side_left");
        ResourceLocation right_side = Blockstates.inAPBlockFolder("bread_block_side_right");
        ModelBuilder wholeModel = ((BlockModelBuilder)this.models().cube("block/bread_block_whole", whole_bottom, whole_top, whole_side, whole_side, whole_side, whole_side)).texture("particle", inside);
        ModelBuilder rightModel = ((BlockModelBuilder)this.models().cube("block/bread_block_right", right_bottom, right_top, heel, inside, right_side, left_side)).texture("particle", inside);
        ModelBuilder leftModel = ((BlockModelBuilder)this.models().cube("block/bread_block_left", left_bottom, left_top, inside, heel, left_side, right_side)).texture("particle", inside);
        ModelBuilder middleModel = ((BlockModelBuilder)this.models().cube("block/bread_block_middle", middle_bottom, middle_top, inside, inside, middle_side, middle_side)).texture("particle", inside);
        this.getVariantBuilder(block).forAllStates(arg_0 -> Blockstates.lambda$breadBlock$2((ModelFile)wholeModel, (ModelFile)leftModel, (ModelFile)rightModel, (ModelFile)middleModel, arg_0));
        ((ItemModelBuilder)this.itemModels().getBuilder("bread_block")).parent((ModelFile)rightModel);
    }

    private void breadSlab(Block block) {
        ResourceLocation top = Blockstates.inAPBlockFolder("bread_block_inside");
        ResourceLocation sides = Blockstates.inAPBlockFolder("bread_block_side");
        ModelBuilder doubleModel = this.models().cubeColumn("double_bread_slab", sides, top);
        ModelBuilder upper = this.models().slabTop("bread_slab_top", sides, top, top);
        ModelBuilder lower = this.models().slab("bread_slab", sides, top, top);
        this.slabBlock((SlabBlock)block, (ModelFile)lower, (ModelFile)upper, (ModelFile)doubleModel);
        this.simpleBlockItem(block, (ModelFile)lower);
    }

    private void cerebralTiles(Block block) {
        ModelBuilder tex0 = this.models().cubeAll("cerebral_tiles", Blockstates.inAPBlockFolder("cerebral_tiles"));
        ModelBuilder tex1 = this.models().cubeAll("cerebral_tiles_1", Blockstates.inAPBlockFolder("cerebral_tiles_1"));
        ModelBuilder tex2 = this.models().cubeAll("cerebral_tiles_2", Blockstates.inAPBlockFolder("cerebral_tiles_2"));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)tex0), new ConfiguredModel((ModelFile)tex1), new ConfiguredModel((ModelFile)tex2)});
        this.simpleBlockItem(block, (ModelFile)tex0);
    }

    private void stoneModel(BlockNode node) {
        ModelBuilder normal = this.models().cubeAll(node.getName(), Blockstates.inBlockFolder(node.getId()));
        ModelBuilder flipped = ((BlockModelBuilder)this.models().withExistingParent(node.getName() + "_mirrored", Blockstates.inMinecraftBlock("cube_mirrored_all"))).texture("all", Blockstates.inBlockFolder(node.getId()));
        this.getVariantBuilder(node.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)normal), new ConfiguredModel((ModelFile)flipped), ConfiguredModel.builder().modelFile((ModelFile)normal).rotationY(180).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)flipped).rotationY(180).buildLast()});
        this.simpleBlockItem(node.get(), (ModelFile)normal);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$breadBlock$2(ModelFile wholeModel, ModelFile leftModel, ModelFile rightModel, ModelFile middleModel, BlockState state) {
        int yRotation;
        BreadBlock.BreadPart part = (BreadBlock.BreadPart)((Object)state.m_61143_(BreadBlock.PART));
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
        if (part == BreadBlock.BreadPart.WHOLE) {
            return ConfiguredModel.builder().modelFile(wholeModel).build();
        }
        int n = yRotation = axis == Direction.Axis.X ? 270 : 0;
        ModelFile model = part == BreadBlock.BreadPart.LEFT ? leftModel : (part == BreadBlock.BreadPart.RIGHT ? rightModel : middleModel);
        return ConfiguredModel.builder().modelFile(model).rotationY(yRotation).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$nubModel$1(ModelFile nub, ModelFile h_nub, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)DirectionalFacingBlock.FACING);
        if (facing.m_122434_().m_122478_()) {
            return ConfiguredModel.builder().modelFile(nub).rotationX(facing == Direction.UP ? 270 : 90).build();
        }
        return ConfiguredModel.builder().modelFile(h_nub).rotationY(Blockstates.getYRotation(facing)).build();
    }

    private /* synthetic */ ConfiguredModel[] lambda$verticalSlabBlock$0(ModelFile slab, ResourceLocation baseBlock, BlockState state) {
        VerticalSlabBlock.VerticalSlabType type = (VerticalSlabBlock.VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE));
        if (type != VerticalSlabBlock.VerticalSlabType.DOUBLE) {
            return ConfiguredModel.builder().modelFile(slab).rotationY(Blockstates.getYRotation(type.direction)).uvLock(true).build();
        }
        return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(baseBlock)).build();
    }

    static {
        currentModelName = dummy = new ResourceLocation("dummy:dummy");
        TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    }

    private static class WrappedModelLoaderBuilder<T extends ModelBuilder<T>>
    extends CustomLoaderBuilder<T> {
        private String wrapper_type;
        private BlockModelBuilder wrapped_model;

        public WrappedModelLoaderBuilder(T parent, ExistingFileHelper existingFileHelper) {
            super(ArchitectsPalette.rl("wrapped"), parent, existingFileHelper);
        }

        public BlockModelBuilder setWrapper(String type, BlockModelBuilder builder) {
            this.wrapper_type = type;
            this.wrapped_model = builder;
            return builder;
        }

        public JsonObject toJson(JsonObject json) {
            JsonObject s = super.toJson(json);
            if (this.wrapper_type != null) {
                s.addProperty("wrapper_type", this.wrapper_type);
                s.add("wrapped_model", (JsonElement)this.wrapped_model.toJson());
            }
            return s;
        }
    }

    private record TextureResult(ResourceLocation result, Boolean found) {
        public TextureResult(ResourceLocation possible, Boolean exists, ResourceLocation def) {
            this(exists != false ? possible : def, exists);
        }
    }

    private record NodeTextures(ResourceLocation top, ResourceLocation side, ResourceLocation bottom) {
    }
}

