/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class WarpingRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    public static WarpRecipeType TYPE = new WarpRecipeType();
    private final Ingredient input;
    private final ItemStack output;
    private final ResourceLocation dimension;
    private final ResourceLocation id;

    public WarpingRecipe(ResourceLocation id, Ingredient input, ItemStack output, ResourceLocation dimension) {
        this.input = input;
        this.output = output;
        this.dimension = dimension;
        this.id = id;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.test(inv.m_8020_(0)) && this.dimension.compareTo(worldIn.m_46472_().m_135782_()) == 0;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public ItemStack getResult() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)this.input, (Object[])new Ingredient[0]);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<WarpingRecipe> {
        public WarpingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient input = Ingredient.m_43917_((JsonElement)inputElement);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation dimensionId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"dimension"));
            return new WarpingRecipe(recipeId, input, output, dimensionId);
        }

        @Nullable
        public WarpingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            ResourceLocation dimensionId = buffer.m_130281_();
            return new WarpingRecipe(recipeId, input, output, dimensionId);
        }

        public void toNetwork(FriendlyByteBuf buffer, WarpingRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.m_130085_(recipe.dimension);
        }
    }

    public static class WarpRecipeType
    implements RecipeType<WarpingRecipe> {
        public String toString() {
            return "warping";
        }

        public <C extends Container> Optional<WarpingRecipe> find(C inv, Level world) {
            return world.m_7465_().m_44015_((RecipeType)TYPE, inv, world);
        }
    }
}

