/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class WizardParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Quaternionf rotation;
    private static final Vec3 DEFAULT_PARTICLE_DIRECTION = new Vec3(0.0, 0.0, -1.0);

    protected WizardParticle(ClientLevel level, double xPos, double yPos, double zPos, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(level, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.sprites = sprite;
        this.m_108339_(sprite);
        this.f_107225_ = 6;
        this.m_6569_(2.0f);
        Vec3 facing = new Vec3(xSpeed, ySpeed, zSpeed).m_82541_();
        Vec3 def = DEFAULT_PARTICLE_DIRECTION;
        Vec3 cross = def.m_82537_(facing).m_82541_();
        double rotationAngle = Math.acos(def.m_82526_(facing));
        Vector3f rotationAxis = cross.m_82553_() == 0.0 ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f((float)cross.f_82479_, (float)cross.f_82480_, (float)cross.f_82481_);
        this.rotation = new Quaternionf(new AxisAngle4f((float)rotationAngle, (Vector3fc)rotationAxis));
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        Quaternionf quat;
        Vec3 pos = camera.m_90583_();
        Vector3f center = new Vector3f((float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - pos.f_82479_), (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - pos.f_82480_), (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - pos.f_82481_));
        if (this.f_107231_ == 0.0f) {
            quat = this.rotation;
        } else {
            quat = new Quaternionf((Quaternionfc)this.rotation);
            quat.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quat);
            vector3f.mul(size);
            vector3f.add((Vector3fc)center);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_106827_) {
            this.sprite = p_106827_;
        }

        public Particle createParticle(SimpleParticleType p_106838_, ClientLevel p_106839_, double p_106840_, double p_106841_, double p_106842_, double p_106843_, double p_106844_, double p_106845_) {
            return new WizardParticle(p_106839_, p_106840_, p_106841_, p_106842_, p_106843_, p_106844_, p_106845_, this.sprite);
        }
    }
}

