/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.AEColor;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class BlockRecolorer {
    private static final BiMap<AEColor, Block> STAINED_GLASS_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50147_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50148_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50202_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50203_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50204_).put((Object)AEColor.LIME, (Object)Blocks.f_50205_).put((Object)AEColor.PINK, (Object)Blocks.f_50206_).put((Object)AEColor.GRAY, (Object)Blocks.f_50207_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50208_).put((Object)AEColor.CYAN, (Object)Blocks.f_50209_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50210_).put((Object)AEColor.BLUE, (Object)Blocks.f_50211_).put((Object)AEColor.BROWN, (Object)Blocks.f_50212_).put((Object)AEColor.GREEN, (Object)Blocks.f_50213_).put((Object)AEColor.RED, (Object)Blocks.f_50214_).put((Object)AEColor.BLACK, (Object)Blocks.f_50215_).build());
    private static final BiMap<AEColor, Block> STAINED_GLASS_PANE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50303_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50304_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50305_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50306_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50307_).put((Object)AEColor.LIME, (Object)Blocks.f_50361_).put((Object)AEColor.PINK, (Object)Blocks.f_50362_).put((Object)AEColor.GRAY, (Object)Blocks.f_50363_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50364_).put((Object)AEColor.CYAN, (Object)Blocks.f_50365_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50366_).put((Object)AEColor.BLUE, (Object)Blocks.f_50367_).put((Object)AEColor.BROWN, (Object)Blocks.f_50368_).put((Object)AEColor.GREEN, (Object)Blocks.f_50369_).put((Object)AEColor.RED, (Object)Blocks.f_50370_).put((Object)AEColor.BLACK, (Object)Blocks.f_50371_).build());
    private static final BiMap<AEColor, Block> WOOL_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50041_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50042_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50096_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50097_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50098_).put((Object)AEColor.LIME, (Object)Blocks.f_50099_).put((Object)AEColor.PINK, (Object)Blocks.f_50100_).put((Object)AEColor.GRAY, (Object)Blocks.f_50101_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50102_).put((Object)AEColor.CYAN, (Object)Blocks.f_50103_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50104_).put((Object)AEColor.BLUE, (Object)Blocks.f_50105_).put((Object)AEColor.BROWN, (Object)Blocks.f_50106_).put((Object)AEColor.GREEN, (Object)Blocks.f_50107_).put((Object)AEColor.RED, (Object)Blocks.f_50108_).put((Object)AEColor.BLACK, (Object)Blocks.f_50109_).build());
    private static final BiMap<AEColor, Block> BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50414_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50415_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50416_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50417_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50418_).put((Object)AEColor.LIME, (Object)Blocks.f_50419_).put((Object)AEColor.PINK, (Object)Blocks.f_50420_).put((Object)AEColor.GRAY, (Object)Blocks.f_50421_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50422_).put((Object)AEColor.CYAN, (Object)Blocks.f_50423_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50424_).put((Object)AEColor.BLUE, (Object)Blocks.f_50425_).put((Object)AEColor.BROWN, (Object)Blocks.f_50426_).put((Object)AEColor.GREEN, (Object)Blocks.f_50427_).put((Object)AEColor.RED, (Object)Blocks.f_50428_).put((Object)AEColor.BLACK, (Object)Blocks.f_50429_).build());
    private static final BiMap<AEColor, Block> WALL_BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50430_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50431_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50432_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50433_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50434_).put((Object)AEColor.LIME, (Object)Blocks.f_50435_).put((Object)AEColor.PINK, (Object)Blocks.f_50436_).put((Object)AEColor.GRAY, (Object)Blocks.f_50437_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50438_).put((Object)AEColor.CYAN, (Object)Blocks.f_50439_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50388_).put((Object)AEColor.BLUE, (Object)Blocks.f_50389_).put((Object)AEColor.BROWN, (Object)Blocks.f_50390_).put((Object)AEColor.GREEN, (Object)Blocks.f_50391_).put((Object)AEColor.RED, (Object)Blocks.f_50392_).put((Object)AEColor.BLACK, (Object)Blocks.f_50393_).build());
    private static final BiMap<AEColor, Block> CARPET_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50336_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50337_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50338_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50339_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50340_).put((Object)AEColor.LIME, (Object)Blocks.f_50341_).put((Object)AEColor.PINK, (Object)Blocks.f_50342_).put((Object)AEColor.GRAY, (Object)Blocks.f_50343_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50344_).put((Object)AEColor.CYAN, (Object)Blocks.f_50345_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50346_).put((Object)AEColor.BLUE, (Object)Blocks.f_50347_).put((Object)AEColor.BROWN, (Object)Blocks.f_50348_).put((Object)AEColor.GREEN, (Object)Blocks.f_50349_).put((Object)AEColor.RED, (Object)Blocks.f_50350_).put((Object)AEColor.BLACK, (Object)Blocks.f_50351_).build());
    private static final BiMap<AEColor, Block> TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50287_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50288_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50289_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50290_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50291_).put((Object)AEColor.LIME, (Object)Blocks.f_50292_).put((Object)AEColor.PINK, (Object)Blocks.f_50293_).put((Object)AEColor.GRAY, (Object)Blocks.f_50294_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50295_).put((Object)AEColor.CYAN, (Object)Blocks.f_50296_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50297_).put((Object)AEColor.BLUE, (Object)Blocks.f_50298_).put((Object)AEColor.BROWN, (Object)Blocks.f_50299_).put((Object)AEColor.GREEN, (Object)Blocks.f_50300_).put((Object)AEColor.RED, (Object)Blocks.f_50301_).put((Object)AEColor.BLACK, (Object)Blocks.f_50302_).build());
    private static final BiMap<AEColor, Block> GLAZED_TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50526_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50527_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50528_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50529_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50530_).put((Object)AEColor.LIME, (Object)Blocks.f_50531_).put((Object)AEColor.PINK, (Object)Blocks.f_50532_).put((Object)AEColor.GRAY, (Object)Blocks.f_50533_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50534_).put((Object)AEColor.CYAN, (Object)Blocks.f_50535_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50536_).put((Object)AEColor.BLUE, (Object)Blocks.f_50537_).put((Object)AEColor.BROWN, (Object)Blocks.f_50538_).put((Object)AEColor.GREEN, (Object)Blocks.f_50539_).put((Object)AEColor.RED, (Object)Blocks.f_50540_).put((Object)AEColor.BLACK, (Object)Blocks.f_50541_).build());
    private static final BiMap<AEColor, Block> CONCRETE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.f_50542_).put((Object)AEColor.ORANGE, (Object)Blocks.f_50543_).put((Object)AEColor.MAGENTA, (Object)Blocks.f_50544_).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.f_50545_).put((Object)AEColor.YELLOW, (Object)Blocks.f_50494_).put((Object)AEColor.LIME, (Object)Blocks.f_50495_).put((Object)AEColor.PINK, (Object)Blocks.f_50496_).put((Object)AEColor.GRAY, (Object)Blocks.f_50497_).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.f_50498_).put((Object)AEColor.CYAN, (Object)Blocks.f_50499_).put((Object)AEColor.PURPLE, (Object)Blocks.f_50500_).put((Object)AEColor.BLUE, (Object)Blocks.f_50501_).put((Object)AEColor.BROWN, (Object)Blocks.f_50502_).put((Object)AEColor.GREEN, (Object)Blocks.f_50503_).put((Object)AEColor.RED, (Object)Blocks.f_50504_).put((Object)AEColor.BLACK, (Object)Blocks.f_50505_).build());
    private static final List<RecolorableBlockGroup> BLOCK_GROUPS = ImmutableList.of((Object)new RecolorableBlockGroup(Blocks.f_50058_, STAINED_GLASS_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50185_, STAINED_GLASS_PANE_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50041_, WOOL_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50414_, BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50430_, WALL_BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50336_, CARPET_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50352_, TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, GLAZED_TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, CONCRETE_BY_COLOR));

    private BlockRecolorer() {
    }

    public static Block recolor(Block block, AEColor newColor) {
        Objects.requireNonNull(block);
        for (RecolorableBlockGroup group : BLOCK_GROUPS) {
            if (group.uncoloredVariant != block && !group.coloredVariants.containsValue((Object)block)) continue;
            Block newBlock = (Block)group.coloredVariants.get((Object)newColor);
            if (newBlock == null) {
                newBlock = group.uncoloredVariant != null ? group.uncoloredVariant : block;
            }
            return newBlock;
        }
        return block;
    }

    private static class RecolorableBlockGroup {
        final Block uncoloredVariant;
        final BiMap<AEColor, Block> coloredVariants;

        public RecolorableBlockGroup(Block uncoloredVariant, BiMap<AEColor, Block> coloredVariants) {
            this.uncoloredVariant = uncoloredVariant;
            this.coloredVariants = coloredVariants;
        }
    }
}

