/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public abstract class GeneratorTile<T extends GeneratorTile<T>>
extends PoweredTile<T> {
    @Save
    private ProgressBarComponent<T> progressBar = this.getProgressBar().setComponentHarness((GeneratorTile)this.getSelf()).setCanIncrease(tileEntity -> !this.isSmart() || this.getEnergyCapacity() - this.getEnergyStorage().getEnergyStored() >= this.getEnergyProducedEveryTick()).setIncreaseType(false).setOnStart(() -> {
        this.progressBar.setMaxProgress(this.consumeFuel());
        this.progressBar.setProgress(this.progressBar.getMaxProgress());
        this.markForUpdate();
    }).setCanReset(tileEntity -> this.canStart() && this.progressBar.getProgress() == 0).setOnTickWork(() -> this.getEnergyStorage().setEnergyStored(this.getEnergyProducedEveryTick() + this.getEnergyStorage().getEnergyStored()));

    public GeneratorTile(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.addProgressBar(this.progressBar);
    }

    public abstract int consumeFuel();

    public abstract boolean canStart();

    public abstract int getEnergyProducedEveryTick();

    public abstract ProgressBarComponent<T> getProgressBar();

    public abstract int getEnergyCapacity();

    public abstract int getExtractingEnergy();

    public boolean isSmart() {
        return true;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        for (Direction facing : Direction.values()) {
            BlockPos checking = this.f_58858_.m_121945_(facing);
            BlockEntity checkingTile = this.f_58857_.m_7702_(checking);
            if (checkingTile == null) continue;
            checkingTile.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(storage -> this.getEnergyStorage().extractEnergy(storage.receiveEnergy(this.getEnergyStorage().extractEnergy(this.getExtractingEnergy(), true), false), false));
        }
    }

    @Override
    @Nonnull
    protected EnergyStorageComponent<T> createEnergyStorage() {
        return new EnergyStorageComponent(this.getEnergyCapacity(), 0, this.getExtractingEnergy(), 10, 20);
    }
}

