/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record UpdateTeam(String teamName, Set<UUID> players) {

    public static class Serializer
    implements PacketSerializer<UpdateTeam> {
        public Class<UpdateTeam> messageClass() {
            return UpdateTeam.class;
        }

        public void encode(UpdateTeam msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.teamName);
            buffer.m_130130_(msg.players.size());
            for (UUID id : msg.players) {
                buffer.m_130077_(id);
            }
        }

        public UpdateTeam decode(FriendlyByteBuf buffer) {
            String teamName = buffer.m_130277_();
            int size = buffer.m_130242_();
            HashSet ids = Sets.newHashSet();
            for (int i = 0; i < size; ++i) {
                ids.add(buffer.m_130259_());
            }
            return new UpdateTeam(teamName, ids);
        }
    }

    public static class Handler
    implements PacketHandler<UpdateTeam> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(UpdateTeam msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (!player.m_20310_(2)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("missing_permissions", new Object[0]));
                return true;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team"));
                return true;
            }
            PlayerList playerList = level.m_7654_().m_6846_();
            Pair result = SkyblockHooks.onManageRemoveFromTeam(null, (Team)team, (Collection)msg.players.stream().map(arg_0 -> ((PlayerList)playerList).m_11259_(arg_0)).collect(Collectors.toList()));
            if (((Boolean)result.getLeft()).booleanValue()) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.remove_players_from_team"));
                return true;
            }
            if (team.getName().equalsIgnoreCase(msg.teamName)) {
                for (UUID id : msg.players) {
                    if (!team.hasPlayer(id)) continue;
                    data.removePlayerFromTeam(id);
                    ServerPlayer toRemove = playerList.m_11259_(id);
                    if (toRemove == null) continue;
                    if (InventoryConfig.dropItems) {
                        RandomUtility.dropInventories((Player)toRemove);
                    }
                    WorldUtil.teleportToIsland((ServerPlayer)toRemove, (Team)data.getSpawn());
                }
            } else {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("player_not_in_team", new Object[0]));
                return true;
            }
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.remove_multiple_players", (Object[])new Object[]{msg.players.size(), team.getName()}));
            return true;
        }
    }
}

