/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record LeaveTeam(UUID player) {

    public static class Serializer
    implements PacketSerializer<LeaveTeam> {
        public Class<LeaveTeam> messageClass() {
            return LeaveTeam.class;
        }

        public void encode(LeaveTeam msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.player);
        }

        public LeaveTeam decode(FriendlyByteBuf buffer) {
            return new LeaveTeam(buffer.m_130259_());
        }
    }

    public static class Handler
    implements PacketHandler<LeaveTeam> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(LeaveTeam msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            SkyblockSavedData data = SkyblockSavedData.get((Level)player.m_9236_());
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED));
                return true;
            }
            switch (SkyblockHooks.onLeave((ServerPlayer)player, (Team)team)) {
                case DENY: {
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.leave_team").m_130940_(ChatFormatting.RED));
                    return true;
                }
                case DEFAULT: {
                    if (PermissionsConfig.selfManage || player.m_20310_(2)) break;
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.manage_teams").m_130940_(ChatFormatting.RED));
                    return true;
                }
            }
            if (InventoryConfig.dropItems) {
                RandomUtility.dropInventories((Player)player);
            }
            data.removePlayerFromTeam(msg.player);
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237115_((String)"skyblockbuilder.command.success.left_team"));
            RandomUtility.deleteTeamIfEmpty((SkyblockSavedData)data, (Team)team);
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)data.getSpawn());
            return true;
        }
    }
}

