/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.widget;

import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.widget.ScrollbarWidgetListener;
import de.melanx.skyguis.util.Math2;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;

public class ScrollbarWidget
implements GuiEventListener,
Renderable {
    private static final int SCROLLER_HEIGHT = 15;
    private static final ResourceLocation ICONS = new ResourceLocation(SkyGUIs.getInstance().modid, "textures/gui/icons.png");
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final List<ScrollbarWidgetListener> listeners = new LinkedList<ScrollbarWidgetListener>();
    private final BaseScreen screen;
    private boolean enabled;
    private boolean focused;
    private int offset;
    private int maxOffset;
    private boolean clicked = false;

    public ScrollbarWidget(BaseScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void addListener(ScrollbarWidgetListener listener) {
        this.listeners.add(listener);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280411_(ICONS, this.screen.getRelX() + this.x - 1, this.screen.getRelY() + this.y - 1, this.width + 2, 1, 0.0f, 15.0f, 14, 1, 256, 256);
        guiGraphics.m_280411_(ICONS, this.screen.getRelX() + this.x - 1, this.screen.getRelY() + this.y, this.width + 2, this.height, 0.0f, 17.0f, 14, 12, 256, 256);
        guiGraphics.m_280411_(ICONS, this.screen.getRelX() + this.x - 1, this.screen.getRelY() + this.y + this.height, this.width + 2, 1, 0.0f, 31.0f, 14, 1, 256, 256);
        guiGraphics.m_280218_(ICONS, this.screen.getRelX() + this.x, this.screen.getRelY() + this.y + (int)Math.min((float)(this.height - 15), (float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.enabled ? 0 : 12, 0, 12, 15);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.clicked && Math2.isInBounds(this.x, this.y, this.width, this.height, mouseX -= (double)this.screen.getRelX(), mouseY -= (double)this.screen.getRelY())) {
            this.updateOffset(mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && Math2.isInBounds(this.x, this.y, this.width, this.height, mouseX -= (double)this.screen.getRelX(), mouseY -= (double)this.screen.getRelY())) {
            this.updateOffset(mouseY);
            this.clicked = true;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.enabled) {
            this.setOffset(this.offset + Math.max(Math.min(-((int)scrollDelta), 1), -1));
            return true;
        }
        return false;
    }

    public void updateOffset(double offset) {
        this.setOffset((int)Math.floor((float)(offset - (double)this.y) / (float)(this.height - 15) * (float)this.maxOffset));
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        if (this.offset > maxOffset) {
            this.offset = Math.max(0, maxOffset);
        }
    }

    public void setOffset(int offset) {
        int oldOffset = this.offset;
        if (offset >= 0 && offset <= this.maxOffset) {
            this.offset = offset;
            this.listeners.forEach(l -> l.onOffsetChanged(oldOffset, offset));
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }
}

