/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import com.google.common.collect.Lists;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.CreateTeamScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.info.TeamEditScreen;
import de.melanx.skyguis.client.screen.info.TeamInfoScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.widget.ClickableText;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.config.ClientConfig;
import de.melanx.skyguis.tooltip.SmallTextTooltip;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.Math2;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.moddingx.libx.render.RenderHelper;

public class AllTeamsScreen
extends BaseScreen
implements LoadingResultHandler {
    public static final int ENTRIES = 13;
    private static final Component TEAMS_COMPONENT = ComponentBuilder.text("teams", new Object[0]).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component MEMBERS_COMPONENT = ComponentBuilder.text("members", new Object[0]).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component YOUR_TEAM = ComponentBuilder.text("your_team", new Object[0]);
    private static final Component CLICK_ME = ComponentBuilder.text("click_me", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    private static final Component FILTER = ComponentBuilder.text("filter", new Object[0]);
    private static final Component VISIT_FILTER = ComponentBuilder.text("filter.visits", new Object[0]);
    private static final Component JOIN_REQUEST_FILTER = ComponentBuilder.text("filter.join_requests", new Object[0]);
    private static final Component EMPTY_TEAMS_FILTER = ComponentBuilder.text("filter.empty_teams", new Object[0]);
    private static final int LONGEST_FILTER_TITLE_LENGTH = Math.max(TextHelper.stringLength((FormattedText)VISIT_FILTER), Math.max(TextHelper.stringLength((FormattedText)JOIN_REQUEST_FILTER), TextHelper.stringLength((FormattedText)EMPTY_TEAMS_FILTER)));
    private final SkyblockSavedData data;
    private final List<Team> teams = new ArrayList<Team>();
    private final Team playerTeam;
    private ScrollbarWidget scrollbar;
    private Button yourTeamButton;
    private Button teleportHome;
    private Button teleportSpawn;
    private FilteredCheckbox visitAllowedTeams;
    private FilteredCheckbox joinRequestsAllowedTeams;
    private FilteredCheckbox hideEmptyTeams;
    private CollapsableText filterText;
    private CycleButton<SortOrder> sortOrderButton;
    private SizeableCheckbox invertSort;

    public AllTeamsScreen() {
        super(TEAMS_COMPONENT, 200, 230);
        this.data = SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_);
        this.playerTeam = this.data.getTeamFromPlayer((Player)Minecraft.m_91087_().f_91074_);
    }

    public static void open() {
        SkyGUIs.getNetwork().updateSkyblockSavedData();
        Minecraft.m_91087_().m_91152_((Screen)new AllTeamsScreen());
    }

    protected void m_7856_() {
        if (this.playerTeam == null) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.title("create_team", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new CreateTeamScreen())).m_257505_(Tooltip.m_257550_((Component)BaseScreen.OPEN_NEW_SCREEN)).m_252987_(this.x(10), this.y(199), 160, 20).m_253136_());
            this.yourTeamButton = null;
            this.teleportSpawn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.button("teleport_spawn_long", new Object[0]), button -> {
                SkyGUIs.getNetwork().teleportToTeam(SkyblockSavedData.SPAWN_ID);
                this.getLoadingCircle().setActive(true);
            }).m_252987_(this.x(10), this.y(this.ySize + 5), this.xSize - 20, 20).m_253136_());
        } else {
            MutableComponent component = Component.m_237113_((String)TextHelper.shorten(this.f_96547_, this.playerTeam.getName(), this.xSize - TextHelper.stringLength((FormattedText)YOUR_TEAM) - 40));
            this.yourTeamButton = (Button)this.m_142416_((GuiEventListener)new ClickableText(this.x(15) + TextHelper.stringLength((FormattedText)YOUR_TEAM), this.y(207), TextHelper.DARK_GREEN.getRGB(), (Component)component, button -> this.f_96541_.m_91152_((Screen)new TeamEditScreen(this.playerTeam, this))));
            this.teleportHome = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.button("teleport_home", new Object[0]), button -> {
                SkyGUIs.getNetwork().teleportToTeam(this.playerTeam);
                this.getLoadingCircle().setActive(true);
            }).m_252987_(this.x(10), this.y(this.ySize + 5), this.xSize / 2 - 15, 20).m_253136_());
            this.teleportHome.f_93623_ = this.f_96541_.f_91074_.m_20310_(1) || PermissionsConfig.Teleports.home;
            this.teleportSpawn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.button("teleport_spawn", new Object[0]), button -> {
                SkyGUIs.getNetwork().teleportToTeam(SkyblockSavedData.SPAWN_ID);
                this.getLoadingCircle().setActive(true);
            }).m_252987_(this.x(5 + this.xSize / 2), this.y(this.ySize + 5), this.xSize / 2 - 15, 20).m_253136_());
        }
        this.teleportSpawn.f_93623_ = this.f_96541_.f_91074_.m_20310_(1) || PermissionsConfig.Teleports.spawn;
        int filterSectionStart = this.xSize + 7;
        this.filterText = (CollapsableText)this.m_142416_((GuiEventListener)new CollapsableText(false, this.x(filterSectionStart), this.y(2), 18, FILTER));
        this.visitAllowedTeams = (FilteredCheckbox)this.m_142416_((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(22), 10, this.visitAllowedTeams != null && this.visitAllowedTeams.f_93822_));
        this.joinRequestsAllowedTeams = (FilteredCheckbox)this.m_142416_((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(36), 10, this.joinRequestsAllowedTeams != null && this.joinRequestsAllowedTeams.f_93822_));
        this.hideEmptyTeams = (FilteredCheckbox)this.m_142416_((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(50), 10, this.hideEmptyTeams == null || this.hideEmptyTeams.f_93822_));
        this.sortOrderButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(SortOrder::getName).m_168961_((Object[])SortOrder.values()).m_168948_((Object)SortOrder.ALPHABETICAL).m_168936_(this.x(filterSectionStart + 15), this.y(65), 120, 20, (Component)ComponentBuilder.button("filter.sort_by", new Object[0]), (button, value) -> this.updateTeams()));
        this.invertSort = (SizeableCheckbox)this.m_142416_((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(70), 10, false, (Component)ComponentBuilder.button("filter.invert", new Object[0])));
        this.scrollbar = new ScrollbarWidget(this, this.xSize - 20, 33, 12, this.ySize - 45);
        this.updateTeams();
        this.updateScrollbar();
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderHelper.renderGuiBackground((GuiGraphics)guiGraphics, (int)this.x(this.xSize), (int)this.y(0), (int)((this.filterText.isOpen() ? LONGEST_FILTER_TITLE_LENGTH + 15 : TextHelper.stringLength((FormattedText)this.filterText.m_6035_())) + 14), (int)(this.filterText.isOpen() ? 95 : 22), (ResourceLocation)BaseScreen.GENERIC, (int)128, (int)64, (int)4, (int)125, (int)4, (int)60);
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        this.scrollbar.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237119_().m_7220_(TEAMS_COMPONENT).m_130946_(" (" + this.teams.size() + "/" + (this.data.getSpawnOption().isPresent() ? this.data.getTeams().size() - 1 : this.data.getTeams().size()) + ")"), this.x(10), this.y(13), Color.DARK_GRAY.getRGB(), false);
        int memberLength = this.f_96547_.m_92724_(MEMBERS_COMPONENT.m_7532_());
        guiGraphics.m_280614_(this.f_96547_, MEMBERS_COMPONENT, this.x(179) - memberLength, this.y(13), Color.DARK_GRAY.getRGB(), false);
        if (this.filterText.isOpen()) {
            int filterSectionStart = this.x(this.xSize + 20);
            guiGraphics.m_280614_(this.f_96547_, VISIT_FILTER, filterSectionStart, this.y(23), Color.DARK_GRAY.getRGB(), false);
            guiGraphics.m_280614_(this.f_96547_, JOIN_REQUEST_FILTER, filterSectionStart, this.y(37), Color.DARK_GRAY.getRGB(), false);
            guiGraphics.m_280614_(this.f_96547_, EMPTY_TEAMS_FILTER, filterSectionStart, this.y(51), Color.DARK_GRAY.getRGB(), false);
        }
        if (this.playerTeam != null) {
            guiGraphics.m_280656_(this.x(8), this.x(this.xSize - 26), this.y(197), Color.GRAY.getRGB());
            guiGraphics.m_280614_(this.f_96547_, YOUR_TEAM, this.x(10), this.y(207), Color.DARK_GRAY.getRGB(), false);
            if (this.yourTeamButton.f_93622_) {
                this.renderTeamTooltip(guiGraphics, mouseX, mouseY, this.playerTeam);
            }
        }
        int j = 0;
        for (int i = this.scrollbar.getOffset(); i < this.teams.size() && j < 13; ++j, ++i) {
            Team team = this.teams.get(i);
            String name = team.getName();
            String s = TextHelper.shorten(this.f_96547_, name, 175 - memberLength);
            String playerSizeComponent = String.valueOf(team.getPlayers().size());
            MutableComponent teamNameComponent = Component.m_237113_((String)s);
            float x = this.x(179.0f - (float)memberLength / 2.0f - (float)this.f_96547_.m_92895_(playerSizeComponent) / 2.0f);
            int y = this.y(37 + j * 12);
            guiGraphics.m_280614_(this.f_96547_, (Component)teamNameComponent, this.x(10), y, team.isEmpty() ? TextHelper.LIGHT_RED.getRGB() : TextHelper.DARK_GREEN.getRGB(), false);
            guiGraphics.drawString(this.f_96547_, playerSizeComponent, x, (float)y, Color.DARK_GRAY.getRGB(), false);
            boolean inBounds = Math2.isInBounds(this.x(10), y, this.f_96547_.m_92724_(teamNameComponent.m_7532_()), 11.0, mouseX, mouseY);
            if (!inBounds) continue;
            this.renderTeamTooltip(guiGraphics, mouseX, mouseY, team);
        }
    }

    private void renderTeamTooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, @Nonnull Team team) {
        ArrayList textLines = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)team.getName()), CLICK_ME});
        ArrayList smallTextLines = Lists.newArrayList();
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92125_) {
            smallTextLines.add(ComponentBuilder.text("team_id", new Object[0]).m_130946_(": " + team.getId().toString()));
        }
        smallTextLines.add(ComponentBuilder.text("members", new Object[0]).m_130946_(": " + team.getPlayers().size()));
        smallTextLines.add(ComponentBuilder.text("created_at", new Object[0]).m_130946_(": " + ClientConfig.date.format(new Date(team.getCreatedAt()))));
        smallTextLines.add(ComponentBuilder.text("last_changed", new Object[0]).m_130946_(": " + ClientConfig.date.format(new Date(team.getLastChanged()))));
        guiGraphics.m_280677_(this.f_96541_.f_91062_, (List)textLines, Optional.of(new SmallTextTooltip(smallTextLines, Color.GRAY)), mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollbar.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int entries = Math.min(13, this.teams.size());
        if (Math2.isInBounds(10.0, 37.0, 175.0, entries * 12, mouseX -= (double)this.relX, mouseY -= (double)this.relY)) {
            int index = (int)((mouseY - 37.0) / 12.0) + this.scrollbar.getOffset();
            Team team = this.teams.get(index);
            if (Math2.isInBounds(10.0, 37.0, this.f_96547_.m_92895_(team.getName()), entries * 12, mouseX, mouseY)) {
                if (team.hasPlayer((Player)this.f_96541_.f_91074_)) {
                    this.f_96541_.m_91152_((Screen)new TeamEditScreen(team, this));
                } else {
                    this.f_96541_.m_91152_((Screen)new TeamInfoScreen(team, this));
                }
            }
            return true;
        }
        return super.m_6375_(mouseX + (double)this.relX, mouseY + (double)this.relY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.scrollbar.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6348_(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollbar.m_6050_(mouseX, mouseY, delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.teams.size() > 13);
        this.scrollbar.setMaxOffset(this.teams.size() - 13);
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        switch (result.status()) {
            case SUCCESS: {
                this.m_7379_();
                break;
            }
            case FAIL: {
                this.f_96541_.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)this.f_96541_).popGuiLayer()));
            }
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.visitAllowedTeams != null && this.joinRequestsAllowedTeams != null && this.hideEmptyTeams != null && this.sortOrderButton != null && this.invertSort != null) {
            boolean showFilter;
            this.visitAllowedTeams.f_93624_ = showFilter = this.filterText.isOpen();
            this.joinRequestsAllowedTeams.f_93624_ = showFilter;
            this.hideEmptyTeams.f_93624_ = showFilter;
            this.sortOrderButton.f_93624_ = showFilter;
            this.invertSort.f_93624_ = showFilter;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20310_(1)) {
            return;
        }
        SkyMeta metaInfo = this.data.getOrCreateMetaInfo((Player)player);
        if (PermissionsConfig.Teleports.home && this.playerTeam != null) {
            if (metaInfo.canTeleportHome(level.m_46467_())) {
                this.teleportHome.m_257544_(null);
                this.teleportHome.f_93623_ = true;
            } else {
                this.teleportHome.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.homeCooldown - (level.m_46467_() - metaInfo.getLastHomeTeleport())))})));
                this.teleportHome.f_93623_ = false;
            }
        }
        if (PermissionsConfig.Teleports.spawn) {
            if (metaInfo.canTeleportSpawn(level.m_46467_())) {
                this.teleportSpawn.m_257544_(null);
                this.teleportSpawn.f_93623_ = true;
            } else {
                this.teleportSpawn.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.spawnCooldown - (level.m_46467_() - metaInfo.getLastSpawnTeleport())))})));
                this.teleportSpawn.f_93623_ = false;
            }
        }
    }

    private void updateTeams() {
        this.teams.clear();
        Predicate<Team> visitsAllowed = team -> {
            if (this.visitAllowedTeams == null) {
                return true;
            }
            return !this.visitAllowedTeams.f_93822_ || team.allowsVisits();
        };
        Predicate<Team> joinRequestsAllowed = team -> {
            if (this.joinRequestsAllowedTeams == null) {
                return true;
            }
            return !this.joinRequestsAllowedTeams.f_93822_ || team.allowsJoinRequests();
        };
        Predicate<Team> hideEmptyTeams = team -> {
            if (this.hideEmptyTeams == null) {
                return true;
            }
            return !this.hideEmptyTeams.f_93822_ || !team.isEmpty();
        };
        this.teams.addAll(this.data.getTeams().stream().filter(team -> !team.getName().isEmpty()).filter(team -> !team.isSpawn()).filter(visitsAllowed).filter(joinRequestsAllowed).filter(hideEmptyTeams).sorted(((SortOrder)((Object)this.sortOrderButton.m_168883_())).comparator(this.invertSort.f_93822_)).toList());
        this.updateScrollbar();
        this.filterText.setAppendix("(" + this.countEnabledFilters() + ")");
    }

    public int countEnabledFilters() {
        int i = 0;
        if (this.visitAllowedTeams != null && this.visitAllowedTeams.f_93822_) {
            ++i;
        }
        if (this.joinRequestsAllowedTeams != null && this.joinRequestsAllowedTeams.f_93822_) {
            ++i;
        }
        if (this.hideEmptyTeams != null && this.hideEmptyTeams.f_93822_) {
            ++i;
        }
        return i;
    }

    private static class CollapsableText
    extends AbstractWidget {
        private boolean enabled;
        private Component appendix = Component.m_237119_();

        public CollapsableText(boolean open, int x, int y, int height, Component message) {
            super(x, y, 0, height, message);
            this.enabled = open;
            this.f_93618_ = TextHelper.stringLength((FormattedText)this.m_6035_());
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.enabled = !this.enabled;
        }

        protected void m_87963_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderHelper.resetColor();
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_(), this.m_252907_() + (this.f_93619_ - 8) / 2, Color.DARK_GRAY.getRGB(), false);
        }

        protected void m_168797_(@Nonnull NarrationElementOutput output) {
            this.m_168802_(output);
        }

        @Nonnull
        public Component m_6035_() {
            return (this.enabled ? Component.m_237113_((String)"\u2b07  ") : Component.m_237113_((String)"\u27a1 ")).m_7220_(super.m_6035_()).m_7220_(this.appendix);
        }

        public boolean isOpen() {
            return this.enabled;
        }

        public void setAppendix(String appendix) {
            this.appendix = Component.m_237113_((String)(" " + appendix));
            this.f_93618_ = TextHelper.stringLength((FormattedText)this.m_6035_());
        }
    }

    private class FilteredCheckbox
    extends SizeableCheckbox {
        public FilteredCheckbox(int x, int y, int size, boolean selected) {
            this(x, y, size, selected, (Component)Component.m_237119_());
        }

        public FilteredCheckbox(int x, int y, int size, boolean selected, Component component) {
            super(x, y, size, selected, component);
        }

        public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.f_93624_) {
                super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public void m_5691_() {
            super.m_5691_();
            AllTeamsScreen.this.updateTeams();
        }
    }

    public static enum SortOrder {
        ALPHABETICAL((Component)ComponentBuilder.button("filter.alphabetical", new Object[0]), Comparator.comparing(team -> team.getName().toLowerCase(Locale.ROOT))),
        CREATION_DATE((Component)ComponentBuilder.button("filter.creation_date", new Object[0]), Comparator.comparing(Team::getCreatedAt)),
        LAST_MODIFIED((Component)ComponentBuilder.button("filter.last_modified", new Object[0]), Comparator.comparing(Team::getLastChanged)),
        MEMBER_COUNT((Component)ComponentBuilder.button("filter.member_count", new Object[0]), Comparator.comparing(team -> team.getPlayers().size()));

        private final Component name;
        private final Comparator<Team> comparator;

        private SortOrder(Component name, Comparator<Team> comparator) {
            this.name = name;
            this.comparator = comparator;
        }

        public Component getName() {
            return this.name;
        }

        public Comparator<Team> comparator() {
            return this.comparator(false);
        }

        public Comparator<Team> comparator(boolean invert) {
            return invert ? this.comparator.reversed() : this.comparator;
        }
    }
}

