/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.template.TemplateRenderer;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CreateTeamScreen
extends BaseScreen
implements LoadingResultHandler {
    private static final Component NAME_COMPONENT = ComponentBuilder.text("name", new Object[0]);
    private static final Component TEMPLATE_COMPONENT = ComponentBuilder.raw("template", new Object[0]);
    private static final Component SETTINGS_COMPONENT = ComponentBuilder.text("settings", new Object[0]);
    private static final Component CREATE = ComponentBuilder.button("create", new Object[0]);
    private static final Component ABORT = ComponentBuilder.button("abort", new Object[0]);
    private static final Component TITLE = ComponentBuilder.title("create_team", new Object[0]);
    private static final Component ALLOW_VISITS = ComponentBuilder.text("allow_visits", new Object[0]);
    private static final Component ALLOW_REQUESTS = ComponentBuilder.text("allow_requests", new Object[0]);
    private final transient Map<String, TemplateRenderer> structureCache = new HashMap<String, TemplateRenderer>();
    private final List<String> templates = TemplateLoader.getTemplateNames();
    private String currTemplate;
    private EditBox name;
    private int currIndex = 0;
    private boolean enableTooltip;
    private Button templateButton;
    private SizeableCheckbox allowVisits;
    private SizeableCheckbox allowJoinRequests;

    public CreateTeamScreen() {
        super(TITLE, 200, 147);
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new CreateTeamScreen());
    }

    protected void m_7856_() {
        this.name = new EditBox(this.f_96547_, this.x(66), this.y(30), 120, 20, (Component)Component.m_237119_());
        this.name.m_94199_(Short.MAX_VALUE);
        this.name.m_94144_(this.name.m_94155_());
        this.name.m_94199_(64);
        this.m_142416_((GuiEventListener)this.name);
        if (this.templates.isEmpty()) {
            Minecraft.m_91087_().m_91152_(null);
            Minecraft.m_91087_().f_91074_.m_213846_((Component)ComponentBuilder.text("empty_templates", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}));
            return;
        }
        Component shortened = this.setCurrentTemplateAndGetShortenedName();
        this.templateButton = Button.m_253074_((Component)shortened, button -> {
            ++this.currIndex;
            if (this.currIndex >= this.templates.size()) {
                this.currIndex = 0;
            }
            Component s = this.setCurrentTemplateAndGetShortenedName();
            button.m_93666_(s);
            this.updateTemplateButton();
        }).m_252987_(this.x(65), this.y(60), 122, 20).m_253136_();
        this.allowVisits = new SizeableCheckbox(this.x(65), this.y(85), 10, false);
        this.allowJoinRequests = new SizeableCheckbox(this.x(65), this.y(100), 10, false);
        this.m_142416_((GuiEventListener)this.allowVisits);
        this.m_142416_((GuiEventListener)this.allowJoinRequests);
        this.updateTemplateButton();
        if (this.templates.size() == 1) {
            this.templateButton.f_93623_ = false;
        }
        this.currTemplate = this.templates.get(this.currIndex);
        this.m_142416_((GuiEventListener)this.templateButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CREATE, button -> {
            if (this.name.m_94155_().isBlank()) {
                this.name.m_93692_(true);
                this.name.m_94144_(NameGenerator.randomName((Random)new Random()));
            } else {
                SkyGUIs.getNetwork().handleCreateTeam(this.name.m_94155_().strip(), this.currTemplate, this.allowVisits.f_93822_, this.allowJoinRequests.f_93822_);
                this.getLoadingCircle().setActive(true);
            }
        }).m_252987_(this.x(27), this.y(116), 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ABORT, button -> this.m_7379_()).m_252987_(this.x(106), this.y(116), 60, 20).m_253136_());
    }

    private Component setCurrentTemplateAndGetShortenedName() {
        String orig = this.templates.get(this.currIndex);
        ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate((String)orig);
        if (configuredTemplate == null) {
            throw new IllegalStateException("Templates not synced between client and server: " + orig);
        }
        Component nameComponent = configuredTemplate.getNameComponent();
        String s = TextHelper.shorten(this.f_96547_, nameComponent.getString(), 110);
        String desc = configuredTemplate.getDescriptionComponent().getString();
        this.enableTooltip = !s.equals(nameComponent.getString()) || !desc.isBlank();
        this.currTemplate = orig;
        return Component.m_237113_((String)s).m_6270_(nameComponent.m_7383_());
    }

    @Override
    public void m_86600_() {
        this.name.m_94120_();
        super.m_86600_();
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        guiGraphics.m_280614_(this.f_96547_, NAME_COMPONENT, this.x(10), this.y(37), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, TEMPLATE_COMPONENT, this.x(10), this.y(67), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, SETTINGS_COMPONENT, this.x(10), this.y(92), Color.DARK_GRAY.getRGB(), false);
        if (!this.structureCache.containsKey(this.currTemplate)) {
            SkyGUIs.getNetwork().requestTemplateFromServer(this.currTemplate);
            this.structureCache.put(this.currTemplate, null);
            return;
        }
        TemplateRenderer renderer = this.structureCache.get(this.currTemplate);
        if (renderer != null) {
            renderer.render(guiGraphics, this.f_96543_ / 6, this.centeredY(0));
        }
        float scale = 0.9f;
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280614_(this.f_96547_, ALLOW_VISITS, (int)((float)this.x(82) / scale), (int)((float)this.y(87) / scale), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, ALLOW_REQUESTS, (int)((float)this.x(82) / scale), (int)((float)this.y(102) / scale), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        switch (result.status()) {
            case SUCCESS: {
                this.m_7379_();
                break;
            }
            case FAIL: {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
            }
        }
    }

    public void addStructureToCache(String name, ConfiguredTemplate template) {
        this.structureCache.put(name, new TemplateRenderer(template.getTemplate(), 130.0f));
    }

    public void updateTemplateButton() {
        if (this.enableTooltip) {
            ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate((String)this.currTemplate);
            if (configuredTemplate == null) {
                throw new IllegalStateException("Template does not exist: " + this.currTemplate);
            }
            MutableComponent nameComponent = configuredTemplate.getNameComponent().m_6881_();
            MutableComponent descComponent = configuredTemplate.getDescriptionComponent().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
            this.templateButton.m_257544_(Tooltip.m_257550_((Component)nameComponent.m_130946_("\n").m_7220_((Component)descComponent)));
        }
    }
}

