/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.moddingx.libx.render.RenderHelper;

public class RenderHelperFluid {
    public static void renderFluid(GuiGraphics graphics, FluidStack stack, int x, int y, int width, int height) {
        if (!stack.isEmpty()) {
            Fluid fluid = stack.getFluid();
            IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
            int color = properties.getTintColor(stack);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(properties.getStillTexture(stack));
            RenderHelperFluid.renderFluid(graphics, sprite, color, x, y, width, height);
        }
    }

    public static void renderFluid(GuiGraphics graphics, int color, int x, int y, int width, int height) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)Fluids.f_76193_).getStillTexture());
        RenderHelperFluid.renderFluid(graphics, sprite, color, x, y, width, height);
    }

    private static void renderFluid(GuiGraphics graphics, TextureAtlasSprite sprite, int color, int x, int y, int width, int height) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int alpha = color >>> 24 & 0xFF;
        if (alpha > 0) {
            RenderHelper.argb(color);
            if (alpha < 255) {
                RenderSystem.enableBlend();
            }
        } else {
            RenderHelper.rgb(color);
        }
        RenderHelper.repeatBlit(graphics, x, y, width, height, sprite);
        if (alpha > 0 && alpha < 255) {
            RenderSystem.disableBlend();
        }
        RenderHelper.resetColor();
        graphics.m_280168_().m_85849_();
    }
}

