/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.recipe;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.moddingx.libx.base.decoration.DecoratedBlock;
import org.moddingx.libx.base.decoration.DecorationType;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedButton;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceGateBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedHangingSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedPressurePlate;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSlabBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedStairBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWoodBlock;
import org.moddingx.libx.impl.datagen.recipe.ObjectCraftingBuilder;

public class DecorationRecipes {
    public static void defaultRecipes(Block block, RecipeExtension ext) {
        if (block instanceof DecoratedBlock) {
            DecoratedBlock decorated = (DecoratedBlock)block;
            List<Block> logBlocks = Stream.of(DecorationType.LOG, DecorationType.STRIPPED_LOG, DecorationType.WOOD, DecorationType.STRIPPED_WOOD).filter(decorated::has).map(decorated::get).map(b -> b).toList();
            if (!logBlocks.isEmpty()) {
                ObjectCraftingBuilder.buildShapeless(ext, new Object[]{RecipeCategory.BUILDING_BLOCKS, decorated, 4, logBlocks});
            }
        } else if (block instanceof DecoratedWoodBlock) {
            DecoratedWoodBlock decorated = (DecoratedWoodBlock)block;
            if (decorated.log != null && decorated.parent.has(decorated.log)) {
                ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.BUILDING_BLOCKS, decorated, 3, "##", "##", Character.valueOf('#'), decorated.parent.get(decorated.log)});
            }
        } else if (block instanceof DecoratedSlabBlock) {
            DecoratedSlabBlock decorated = (DecoratedSlabBlock)block;
            if (decorated.parent.getContext().material().isStone()) {
                DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 2);
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.BUILDING_BLOCKS, decorated, 6, "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedStairBlock) {
            DecoratedStairBlock decorated = (DecoratedStairBlock)block;
            if (decorated.parent.getContext().material().isStone()) {
                DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 1);
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.BUILDING_BLOCKS, decorated, 4, "#  ", "## ", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedWallBlock) {
            DecoratedWallBlock decorated = (DecoratedWallBlock)block;
            if (decorated.parent.getContext().material().isStone()) {
                DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 1);
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.DECORATIONS, decorated, 6, "###", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedFenceBlock) {
            DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.DECORATIONS, decorated, 3, "#s#", "#s#", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        } else if (block instanceof DecoratedFenceGateBlock) {
            DecoratedFenceGateBlock decorated = (DecoratedFenceGateBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.DECORATIONS, decorated, "s#s", "s#s", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        } else if (block instanceof DecoratedDoorBlock) {
            DecoratedDoorBlock decorated = (DecoratedDoorBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.REDSTONE, decorated, 3, "##", "##", "##", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedTrapdoorBlock) {
            DecoratedTrapdoorBlock decorated = (DecoratedTrapdoorBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.REDSTONE, decorated, 2, "###", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedButton) {
            DecoratedButton decorated = (DecoratedButton)block;
            ObjectCraftingBuilder.buildShapeless(ext, new Object[]{RecipeCategory.REDSTONE, decorated, decorated.parent});
        } else if (block instanceof DecoratedPressurePlate) {
            DecoratedPressurePlate decorated = (DecoratedPressurePlate)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.REDSTONE, decorated, "##", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedSign.Standing) {
            DecoratedSign.Standing decorated = (DecoratedSign.Standing)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.DECORATIONS, decorated, 3, "###", "###", " s ", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        } else if (block instanceof DecoratedHangingSign.Ceiling) {
            DecoratedHangingSign.Ceiling decorated = (DecoratedHangingSign.Ceiling)block;
            if (decorated.parent.has(DecorationType.STRIPPED_LOG)) {
                ObjectCraftingBuilder.buildShaped(ext, new Object[]{RecipeCategory.DECORATIONS, decorated, 3, "c c", "###", "###", Character.valueOf('#'), decorated.parent.get(DecorationType.STRIPPED_LOG), Character.valueOf('c'), Items.f_42026_});
            }
        }
    }

    private static void stoneCutting(RecipeExtension ext, Ingredient input, ItemLike output, int amount) {
        SingleItemRecipeBuilder builder = SingleItemRecipeBuilder.m_246944_((Ingredient)input, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)amount);
        List<CriterionTriggerInstance> criteria = ext.criteria(input);
        for (int i = 0; i < criteria.size(); ++i) {
            builder.m_126132_("has_item" + i, criteria.get(i));
        }
        builder.m_126140_(ext.consumer(), ext.provider().loc(output, "stonecutting"));
    }
}

