/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers.generic;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.GenericValueMapper;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.gui.screen.content.CollectionContent;

public class ListValueMapper<T>
implements GenericValueMapper<List<T>, JsonArray, T> {
    public static final ListValueMapper<?> INSTANCE = new ListValueMapper();

    private ListValueMapper() {
    }

    @Override
    public Class<List<T>> type() {
        return List.class;
    }

    @Override
    public Class<JsonArray> element() {
        return JsonArray.class;
    }

    @Override
    public int getGenericElementPosition() {
        return 0;
    }

    @Override
    public List<T> fromJson(JsonArray json, ValueMapper<T, JsonElement> mapper) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < json.size(); ++i) {
            JsonElement element = json.get(i);
            builder.add(mapper.fromJson(element));
        }
        return builder.build();
    }

    @Override
    public JsonArray toJson(List<T> value, ValueMapper<T, JsonElement> mapper) {
        JsonArray array = new JsonArray();
        for (T element : value) {
            array.add(mapper.toJson(element));
        }
        return array;
    }

    @Override
    public List<T> fromNetwork(FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        int size = buffer.m_130242_();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(mapper.fromNetwork(buffer));
        }
        return builder.build();
    }

    @Override
    public void toNetwork(List<T> value, FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        buffer.m_130130_(value.size());
        for (T element : value) {
            mapper.toNetwork(element, buffer);
        }
    }

    @Override
    public Optional<List<T>> correct(JsonElement json, ValueMapper<T, JsonElement> mapper, ConfigCorrection<List<T>> correction) {
        if (json.isJsonArray()) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < json.getAsJsonArray().size(); ++i) {
                int idx = i;
                correction.tryCorrect(json.getAsJsonArray().get(i), mapper, ConfigCorrection.check(value -> idx < value.size(), value -> value.get(idx))).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
            }
            ImmutableList result = list.build();
            if (result.isEmpty() && json.getAsJsonArray().size() > 0) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return correction.tryCorrect(json, mapper, ConfigCorrection.check(value -> value.size() == 1, value -> value.get(0))).map(ImmutableList::of);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<List<T>> createEditor(ValueMapper<T, JsonElement> mapper, ValidatorInfo<?> validator) {
        return ConfigEditor.custom(List.of(), list -> new CollectionContent(list, mapper.createEditor(ValidatorInfo.empty()), Function.identity(), true));
    }
}

