/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.RendererOnDataGenException;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedButton;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedHangingSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import org.moddingx.libx.mod.ModX;

public abstract class ItemModelProviderBase
extends ItemModelProvider {
    public static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    public static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");
    public static final ResourceLocation DRIPPING_BUCKET = new ResourceLocation("forge", "bucket_drip");
    public static final ResourceLocation SPECIAL_BLOCK_PARENT = LibX.getInstance().resource("item/base/special_block");
    public static final ResourceLocation SPAWN_EGG_PARENT = new ResourceLocation("minecraft", "item/template_spawn_egg");
    public static final ResourceLocation FENCE_PARENT = new ResourceLocation("minecraft", "block/fence_inventory");
    public static final ResourceLocation BUTTON_PARENT = new ResourceLocation("minecraft", "block/button_inventory");
    public static final ResourceLocation WALL_PARENT = new ResourceLocation("minecraft", "block/wall_inventory");
    protected final ModX mod;
    private final Set<Item> handheld = new HashSet<Item>();
    private final Set<Item> ignored = new HashSet<Item>();

    public ItemModelProviderBase(DatagenContext ctx) {
        super(ctx.output(), ctx.mod().modid, ctx.fileHelper());
        this.mod = ctx.mod();
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " item models";
    }

    protected void handheld(Item item) {
        this.handheld.add(item);
    }

    protected void manualModel(Item item) {
        this.ignored.add(item);
    }

    protected void registerModels() {
        this.setup();
        for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys().stream().sorted().toList()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null || !this.mod.modid.equals(id.m_135827_()) || this.ignored.contains(item)) continue;
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                this.defaultBlock(id, blockItem);
                continue;
            }
            if (this.handheld.contains(item)) {
                ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), HANDHELD)).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
                continue;
            }
            this.defaultItem(id, item);
        }
    }

    protected abstract void setup();

    protected void defaultItem(ResourceLocation id, Item item) {
        if (item instanceof SpawnEggItem) {
            this.withExistingParent(id.m_135815_(), SPAWN_EGG_PARENT);
        } else if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), DRIPPING_BUCKET)).texture("base", this.modLoc("item/" + id.m_135815_()))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(bucketItem.getFluid());
        } else {
            ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), GENERATED)).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
        }
    }

    protected void defaultBlock(ResourceLocation id, BlockItem item) {
        if (ItemModelProviderBase.isItemStackRenderer((Item)item)) {
            ((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(SPECIAL_BLOCK_PARENT));
        } else {
            Block block = item.m_40614_();
            if (block instanceof DecoratedFenceBlock) {
                DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
                parentId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)decorated.parent));
                ResourceLocation texture = new ResourceLocation(parentId.m_135827_(), "block/" + parentId.m_135815_());
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(FENCE_PARENT))).texture("texture", texture);
            } else {
                parentId = item.m_40614_();
                if (parentId instanceof DecoratedButton) {
                    DecoratedButton decorated = (DecoratedButton)parentId;
                    parentId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)decorated.parent));
                    ResourceLocation texture = new ResourceLocation(parentId.m_135827_(), "block/" + parentId.m_135815_());
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(BUTTON_PARENT))).texture("texture", texture);
                } else {
                    parentId = item.m_40614_();
                    if (parentId instanceof DecoratedWallBlock) {
                        DecoratedWallBlock decorated = (DecoratedWallBlock)parentId;
                        parentId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)decorated.parent));
                        ResourceLocation texture = new ResourceLocation(parentId.m_135827_(), "block/" + parentId.m_135815_());
                        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(WALL_PARENT))).texture("wall", texture);
                    } else if (item.m_40614_() instanceof DecoratedTrapdoorBlock) {
                        ((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_() + "_bottom")));
                    } else if (item.m_40614_() instanceof DecoratedDoorBlock || item.m_40614_() instanceof DecoratedSign.Standing || item.m_40614_() instanceof DecoratedSign.Wall || item.m_40614_() instanceof DecoratedHangingSign.Ceiling || item.m_40614_() instanceof DecoratedHangingSign.Wall) {
                        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), GENERATED)).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
                    } else {
                        ((ItemModelBuilder)this.getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_())));
                    }
                }
            }
        }
    }

    private static boolean isItemStackRenderer(Item item) {
        try {
            IClientItemExtensions ext = IClientItemExtensions.of((Item)item);
            if (ext != IClientItemExtensions.DEFAULT) {
                ext.getCustomRenderer();
            } else {
                AtomicReference<Object> ref = new AtomicReference<Object>(null);
                item.initializeClient(ref::set);
                ext = ref.get();
                if (ext != null) {
                    ext.getCustomRenderer();
                }
            }
        }
        catch (RendererOnDataGenException e) {
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            return false;
        }
        return false;
    }
}

