/*
 * Decompiled with CFR 0.152.
 */
package zeh.createlowheated.content.processing.basicburner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import zeh.createlowheated.AllTags;
import zeh.createlowheated.common.Configuration;
import zeh.createlowheated.content.processing.basicburner.BasicBurnerBlock;

public class BasicBurnerBlockEntity
extends SmartBlockEntity {
    public static final int MAX_HEAT_CAPACITY = 4000;
    public static final int INSERTION_THRESHOLD = 400;
    protected FuelType activeFuel;
    protected int remainingBurnTime = 0;
    protected int fanMultiplier;
    protected int baseMultiplier;
    protected boolean hotBurners;
    protected BlazeBurnerBlock.HeatLevel activeHeatLevel;
    protected BlazeBurnerBlock.HeatLevel empoweredHeatLevel;
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public LazyOptional<IItemHandler> capability;
    BurnerItemHandler itemHandler = new BurnerItemHandler();

    public BasicBurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.capability = LazyOptional.of(() -> this.itemHandler);
        this.activeFuel = FuelType.NONE;
        this.fanMultiplier = (Integer)Configuration.FAN_MULTIPLIER.get();
        this.baseMultiplier = (Integer)Configuration.BASE_MULTIPLIER.get();
        this.hotBurners = (Boolean)Configuration.HOT_BURNERS.get();
        this.activeHeatLevel = this.hotBurners ? BlazeBurnerBlock.HeatLevel.KINDLED : BlazeBurnerBlock.HeatLevel.valueOf((String)"LOW");
        this.empoweredHeatLevel = this.hotBurners ? BlazeBurnerBlock.HeatLevel.SEETHING : BlazeBurnerBlock.HeatLevel.KINDLED;
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public void setEmpowered(boolean value) {
        if (this.getEmpoweredFromBlock() == value) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BasicBurnerBlock.EMPOWERED, (Comparable)Boolean.valueOf(value)));
        this.notifyUpdate();
    }

    public void tick() {
        super.tick();
        if (!this.getLitFromBlock()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        this.tickFuel();
        if (this.remainingBurnTime > 0) {
            this.remainingBurnTime = this.getEmpoweredFromBlock() ? (this.remainingBurnTime -= this.fanMultiplier) : (this.remainingBurnTime -= this.baseMultiplier);
        }
        if (this.remainingBurnTime < 0) {
            this.remainingBurnTime = 0;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        this.activeFuel = FuelType.NONE;
        if (this.remainingBurnTime == 0 && this.getLitFromBlock()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BasicBurnerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.notifyUpdate();
        }
        this.updateBlockState();
    }

    public void tickFuel() {
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (this.tryUpdateFuel(stackInSlot, false, false)) {
            stackInSlot.m_41774_(1);
            this.inputInv.setStackInSlot(0, stackInSlot);
            if (this.remainingBurnTime > 0 && !((Boolean)this.m_58900_().m_61143_((Property)BasicBurnerBlock.FUELED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BasicBurnerBlock.FUELED, (Comparable)Boolean.valueOf(true)));
                this.notifyUpdate();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        FuelType newFuel = FuelType.NONE;
        if (this.isFuelValid(itemStack)) {
            newFuel = FuelType.NORMAL;
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        int newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime <= 400) {
                newBurnTime += this.remainingBurnTime;
            } else {
                if (!forceOverflow || newFuel != FuelType.NORMAL) return false;
                if (this.remainingBurnTime + newBurnTime >= 4000) return false;
                newBurnTime = Math.min(this.remainingBurnTime + newBurnTime, 4000);
            }
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev == this.getHeatLevelFromBlock()) return true;
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 1.15f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128405_("FuelLevel", this.activeFuel.ordinal());
        compound.m_128405_("BurnTimeRemaining", this.remainingBurnTime);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.activeFuel = FuelType.values()[compound.m_128451_("FuelLevel")];
        this.remainingBurnTime = compound.m_128451_("BurnTimeRemaining");
        super.read(compound, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BasicBurnerBlock.getHeatLevelOf(this.m_58900_());
    }

    public boolean getLitFromBlock() {
        return BasicBurnerBlock.getLitOf(this.m_58900_());
    }

    public boolean getEmpoweredFromBlock() {
        return BasicBurnerBlock.getEmpoweredOf(this.m_58900_());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        if (this.remainingBurnTime == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_(BasicBurnerBlock.HEAT_LEVEL, (Comparable)heat)).m_61124_((Property)BasicBurnerBlock.LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BasicBurnerBlock.FUELED, (Comparable)Boolean.valueOf(false)));
        } else {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BasicBurnerBlock.HEAT_LEVEL, (Comparable)heat));
        }
        this.notifyUpdate();
    }

    public boolean isValidBlockAbove() {
        if (this.isVirtual()) {
            return false;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 0.75f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.NONE;
        if (!this.getLitFromBlock()) {
            return level;
        }
        switch (this.activeFuel) {
            case NORMAL: {
                level = this.getEmpoweredFromBlock() ? this.empoweredHeatLevel : this.activeHeatLevel;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        double yExtra;
        if (this.f_58857_ == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(4) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        if (empty || r.m_188503_(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? (double)0.0325f : r.m_188500_() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.m_188500_() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        double d = yExtra = this.getEmpoweredFromBlock() ? (double)0.02f : 0.0;
        if (!heatLevel.equals((Object)BlazeBurnerBlock.HeatLevel.NONE)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion + yExtra, 0.0);
            if (this.getEmpoweredFromBlock()) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion + yExtra, 0.0);
            }
        }
    }

    public void spawnParticleBurst() {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        RandomSource r = this.f_58857_.f_46441_;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_();
            Vec3 v = c.m_82549_(offset.m_82490_(0.5 + r.m_188500_() * 0.125)).m_82520_(0.0, 0.125, 0.0);
            Vec3 m = offset.m_82490_(0.007751937955617905);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123783_, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public boolean isFuelValid(ItemStack stack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, null);
        boolean tagged = !stack.m_204117_(AllTags.AllItemTags.BASIC_BURNER_FUEL_BLACKLIST.tag) && (stack.m_204117_(AllTags.AllItemTags.BASIC_BURNER_FUEL_WHITELIST.tag) || (Boolean)Configuration.IGNORES_FUEL_TAG_WHITELIST.get() != false);
        return burnTime > 0 && tagged && this.inputInv.isItemValid(0, stack);
    }

    public class BurnerItemHandler
    implements IItemHandler {
        private static final int MAIN_SLOT = 0;

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return BasicBurnerBlockEntity.this.inputInv.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return BasicBurnerBlockEntity.this.inputInv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BasicBurnerBlockEntity.this.isFuelValid(stack) && BasicBurnerBlockEntity.this.inputInv.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack;
            }
            if (!BasicBurnerBlockEntity.this.inputInv.getStackInSlot(0).m_41619_() && !stack.m_150930_(BasicBurnerBlockEntity.this.inputInv.getStackInSlot(0).m_41720_())) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack remainder = BasicBurnerBlockEntity.this.inputInv.insertItem(slot, stack, simulate);
            if (!simulate && remainder != stack) {
                BasicBurnerBlockEntity.this.notifyUpdate();
            }
            return remainder;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack held = BasicBurnerBlockEntity.this.inputInv.getStackInSlot(0);
            if (held == null) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = held.m_41777_();
            ItemStack extracted = stack.m_41620_(amount);
            if (!simulate) {
                BasicBurnerBlockEntity.this.inputInv.setStackInSlot(0, stack);
                BasicBurnerBlockEntity.this.notifyUpdate();
            }
            return extracted;
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL;

    }
}

