/*
 * Decompiled with CFR 0.152.
 */
package zeh.createlowheated;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;
import zeh.createlowheated.AllArmInteractionPointTypes;
import zeh.createlowheated.AllBlockEntityTypes;
import zeh.createlowheated.AllBlocks;
import zeh.createlowheated.AllCreativeModeTabs;
import zeh.createlowheated.AllTags;
import zeh.createlowheated.common.Configuration;
import zeh.createlowheated.infrastructure.data.CreateLowHeatedDatagen;

@Mod(value="createlowheated")
public class CreateLowHeated {
    public static final String ID = "createlowheated";
    public static final String NAME = "Create Low-Heated";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"createlowheated");

    public CreateLowHeated() {
        CreateLowHeated.onCtor();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void onCtor() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        AllTags.init();
        AllCreativeModeTabs.register(modEventBus);
        AllBlocks.register();
        AllBlockEntityTypes.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.COMMON_CONFIG);
        modEventBus.addListener(CreateLowHeated::init);
        modEventBus.addListener(CreateLowHeated::onRegister);
        modEventBus.addListener(EventPriority.LOWEST, CreateLowHeatedDatagen::gatherData);
    }

    public static void onRegister(RegisterEvent event) {
        AllArmInteractionPointTypes.init();
    }

    public static void init(FMLCommonSetupEvent event) {
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

