/*
 * Decompiled with CFR 0.152.
 */
package net.theiadraizer.komarumod.entity.goal;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.theiadraizer.komarumod.entity.KomaruEntity;

public class KomaruRelaxOnOwnerGoal
extends Goal {
    public final KomaruEntity entity;
    @Nullable
    private Player ownerPlayer;
    @Nullable
    private BlockPos goalPos;
    private int onBedTicks;

    public KomaruRelaxOnOwnerGoal(KomaruEntity entity) {
        this.entity = entity;
    }

    public boolean m_8036_() {
        if (!this.entity.m_21824_() || this.entity.m_21827_()) {
            return false;
        }
        LivingEntity owner = this.entity.m_269323_();
        if (!(owner instanceof Player)) {
            return false;
        }
        this.ownerPlayer = (Player)owner;
        if (!owner.m_5803_()) {
            return false;
        }
        if (this.entity.m_20280_((Entity)this.ownerPlayer) > 100.0) {
            return false;
        }
        BlockPos pos = this.ownerPlayer.m_20183_();
        BlockState state = this.entity.m_9236_().m_8055_(pos);
        if (!state.m_204336_(BlockTags.f_13038_)) {
            return false;
        }
        this.goalPos = state.m_61145_((Property)BedBlock.f_54117_).map(direction -> pos.m_121945_(direction.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)pos));
        return !this.spaceIsOccupied();
    }

    private boolean spaceIsOccupied() {
        for (KomaruEntity other : this.entity.m_9236_().m_45976_(KomaruEntity.class, new AABB(this.goalPos).m_82400_(2.0))) {
            if (other == this.entity || !other.isLying()) continue;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.entity.m_21824_() && !this.entity.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
    }

    public void m_8056_() {
        if (this.goalPos != null) {
            this.entity.m_21837_(false);
            this.entity.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
        }
    }

    public void m_8041_() {
        this.entity.setLying(false);
        float f = this.entity.m_9236_().m_46942_(1.0f);
        if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.entity.m_9236_().m_213780_().m_188501_() < 0.7) {
            this.giveMorningGift();
        }
        this.onBedTicks = 0;
        this.entity.m_21573_().m_26573_();
    }

    public void giveMorningGift() {
        RandomSource random = this.entity.m_217043_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)this.entity.m_20183_());
        this.entity.m_20984_(pos.m_123341_() + random.m_188503_(11) - 5, pos.m_123342_() + random.m_188503_(5) - 2, pos.m_123343_() + random.m_188503_(11) - 5, false);
        pos.m_122190_((Vec3i)this.entity.m_20183_());
        ServerLevel level = (ServerLevel)this.entity.m_9236_();
        LootTable lootTable = Objects.requireNonNull(level.m_7654_()).m_278653_().m_278676_(BuiltInLootTables.f_78724_);
        LootParams lootParams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)this.entity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.entity).m_287235_(LootContextParamSets.f_81416_);
        lootTable.m_287195_(lootParams).forEach(stack -> {
            ItemEntity entity = new ItemEntity((Level)level, (double)pos.m_123341_() - (double)Mth.m_14031_((float)(this.entity.f_20883_ * ((float)Math.PI / 180))), (double)pos.m_123342_(), (double)pos.m_123343_() + (double)Mth.m_14089_((float)(this.entity.f_20883_ * ((float)Math.PI / 180))), stack);
            entity.m_9236_().m_7967_((Entity)entity);
        });
    }

    public void m_8037_() {
        if (this.ownerPlayer == null || this.goalPos == null) {
            return;
        }
        this.entity.m_21837_(false);
        this.entity.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
        if (this.entity.m_20280_((Entity)this.ownerPlayer) < 2.5) {
            ++this.onBedTicks;
            if (this.onBedTicks > this.m_183277_(16)) {
                this.entity.setLying(true);
            } else {
                this.entity.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
            }
        } else {
            this.entity.setLying(false);
        }
    }
}

