/*
 * Decompiled with CFR 0.152.
 */
package net.theiadraizer.komarumod.entity;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.theiadraizer.komarumod.entity.goal.KomaruLieGoal;
import net.theiadraizer.komarumod.entity.goal.KomaruRelaxOnOwnerGoal;
import net.theiadraizer.komarumod.entity.goal.KomaruSitOnBlockGoal;
import net.theiadraizer.komarumod.registry.KomaruItems;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KomaruEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_SITTING = SynchedEntityData.m_135353_(KomaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.m_135353_(KomaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(KomaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RABBIT = SynchedEntityData.m_135353_(KomaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FOLLOWING = SynchedEntityData.m_135353_(KomaruEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.walk");
    private static final RawAnimation SITTING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.sitting");
    private static final RawAnimation LAYING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.lie_down");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.sprint");
    private static final RawAnimation BABY_TRANSFORM_ANIM = RawAnimation.begin().thenPlay("animation.komaru.baby_transform");
    private static final RawAnimation RABBIT_ANIM = RawAnimation.begin().thenPlay("animation.komaru.rabbit");
    private static final RawAnimation SLEEPING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.sleep");
    private static final RawAnimation IDLING_ANIM = RawAnimation.begin().thenPlay("animation.komaru.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    FollowOwnerGoal followOwnerGoal = new FollowOwnerGoal((TamableAnimal)this, 1.0, 15.0f, 5.0f, false);

    public KomaruEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new FoxLookControl();
        this.f_21342_ = new FoxMoveControl();
    }

    public boolean canMove() {
        return !this.m_5803_() && !this.m_21827_() && !this.isLying();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::handleAnimations)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RabbitGoal());
        this.f_21345_.m_25352_(10, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new KomaruRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)KomaruItems.KOMARU_POWDER.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new KomaruLieGoal(this, 1.1, 8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new KomaruSitOnBlockGoal(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (!this.m_21824_()) {
            return SoundEvents.f_11786_;
        }
        if (this.m_27593_()) {
            return SoundEvents.f_11792_;
        }
        return this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11791_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        Item isItemForTaming = (Item)KomaruItems.KOMARU_POWDER.get();
        Item isItemForFollowing = Items.f_42399_;
        Level level = this.m_9236_();
        if (!level.f_46443_ && item == isItemForTaming) {
            if (this.m_21824_() && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                return InteractionResult.CONSUME;
            }
            if (!this.m_21824_()) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_5496_(SoundEvents.f_11792_, 1.0f, 1.0f);
                    super.m_21828_(player);
                    this.m_21839_(true);
                    this.setFollowing(true);
                    this.f_21344_.m_26569_();
                    this.m_6710_(null);
                    level.m_7605_((Entity)this, (byte)7);
                } else {
                    level.m_7605_((Entity)this, (byte)6);
                }
                this.m_142075_(player, hand, stack);
                return InteractionResult.CONSUME;
            }
        }
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (this.m_21824_()) {
                this.m_5496_(SoundEvents.f_11792_, 1.0f, 1.0f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20188_() + 0.3, this.m_20262_(1.0), d0, d1, d2);
                }
                this.m_21573_().m_26573_();
                this.f_19797_ = 0;
                return InteractionResult.SUCCESS;
            }
            this.m_5496_(SoundEvents.f_11789_, 1.0f, 1.0f);
        }
        if (this.m_21824_() && !player.m_6144_()) {
            if (item == isItemForFollowing && hand == InteractionHand.MAIN_HAND) {
                this.setFollowing(!this.isFollowing());
                if (level.f_46443_) {
                    assert (Minecraft.m_91087_().f_91074_ != null);
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("Komaru " + (this.isFollowing() ? "follow" : "unfollow") + " owner now")));
                }
                return InteractionResult.SUCCESS;
            }
            if (hand == InteractionHand.MAIN_HAND) {
                this.clearStates();
                this.m_21839_(!this.m_21827_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        this.m_21837_(tag.m_128471_("isSitting"));
        this.setLying(tag.m_128471_("isLying"));
        this.setRabbit(tag.m_128471_("isRabbit"));
        this.setSleeping(tag.m_128471_("isSleeping"));
        this.setFollowing(tag.m_128471_("isFollowing"));
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob mob) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SITTING, (Object)false);
        this.f_19804_.m_135372_(IS_LYING, (Object)false);
        this.f_19804_.m_135372_(IS_RABBIT, (Object)false);
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(IS_FOLLOWING, (Object)true);
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isFollowing", this.isFollowing());
    }

    public void setFollowing(boolean isFollowing) {
        this.f_19804_.m_135381_(IS_FOLLOWING, (Object)isFollowing);
        if (this.isFollowing()) {
            this.f_21345_.m_25352_(2, (Goal)this.followOwnerGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.followOwnerGoal);
        }
    }

    public boolean isFollowing() {
        return (Boolean)this.f_19804_.m_135370_(IS_FOLLOWING);
    }

    public void setLying(boolean isLying) {
        this.f_19804_.m_135381_(IS_LYING, (Object)isLying);
    }

    public boolean isLying() {
        return (Boolean)this.f_19804_.m_135370_(IS_LYING);
    }

    public void setRabbit(boolean isRabbit) {
        this.f_19804_.m_135381_(IS_RABBIT, (Object)isRabbit);
    }

    public boolean isRabbit() {
        return (Boolean)this.f_19804_.m_135370_(IS_RABBIT);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)isSleeping);
    }

    private <E extends GeoAnimatable> PlayState handleAnimations(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALKING_ANIM);
        } else if (this.m_21825_()) {
            event.getController().setAnimation(SITTING_ANIM);
        } else if (this.isLying()) {
            event.getController().setAnimation(LAYING_ANIM);
        } else if (this.m_20142_()) {
            event.getController().setAnimation(SPRINTING_ANIM);
        } else if (this.m_6162_()) {
            event.getController().setAnimation(BABY_TRANSFORM_ANIM);
        } else if (this.isRabbit()) {
            event.getController().setAnimation(RABBIT_ANIM);
        } else if (this.m_5803_()) {
            event.getController().setAnimation(SLEEPING_ANIM);
        } else {
            event.getController().setAnimation(IDLING_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void clearStates() {
        this.setRabbit(false);
        this.setLying(false);
        this.setSleeping(false);
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super((Mob)KomaruEntity.this);
        }

        public void m_8128_() {
            if (!KomaruEntity.this.m_5803_()) {
                super.m_8128_();
            }
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)KomaruEntity.this);
        }

        public void m_8126_() {
            if (KomaruEntity.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class RabbitGoal
    extends Goal {
        private static final int WAIT_TIME_BEFORE_RABBIT = RabbitGoal.m_186073_((int)6000);
        private int countdown;
        private static final int RABBIT_DURATION = RabbitGoal.m_186073_((int)60);
        private int rabbitTimer;

        protected boolean hasShelter() {
            KomaruEntity komaru = KomaruEntity.this;
            BlockPos blockpos = komaru.m_20183_();
            return !komaru.m_9236_().m_45527_(blockpos) && komaru.m_21692_(blockpos) >= 0.0f;
        }

        public RabbitGoal() {
            this.countdown = KomaruEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_RABBIT);
            this.rabbitTimer = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            KomaruEntity komaru = KomaruEntity.this;
            if (komaru.f_20900_ == 0.0f && komaru.f_20901_ == 0.0f && komaru.f_20902_ == 0.0f) {
                return !komaru.isRabbit() && (this.canRabbit() || this.m_8045_()) && !komaru.m_20069_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.rabbitTimer > 0;
        }

        private boolean canRabbit() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return !this.hasShelter();
        }

        public void m_8041_() {
            this.rabbitTimer = 0;
            this.countdown = KomaruEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_RABBIT);
            this.rabbitTimer = 0;
            KomaruEntity.this.setRabbit(false);
        }

        public void m_8056_() {
            KomaruEntity komaru = KomaruEntity.this;
            komaru.setRabbit(true);
            komaru.m_21573_().m_26573_();
            komaru.m_21566_().m_6849_(komaru.m_20185_(), komaru.m_20186_(), komaru.m_20189_(), 0.0);
        }

        public void m_8037_() {
            if (this.canRabbit()) {
                ++this.rabbitTimer;
                if (this.rabbitTimer >= RABBIT_DURATION) {
                    KomaruEntity.this.setSleeping(false);
                    this.rabbitTimer = 0;
                }
            } else {
                this.rabbitTimer = 0;
            }
        }
    }

    class SleepGoal
    extends Goal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)1200);
        private static final int SLEEP_DURATION = SleepGoal.m_186073_((int)600);
        private int countdown;
        private int sleepTimer;

        protected boolean hasShelter() {
            KomaruEntity komaru = KomaruEntity.this;
            BlockPos blockpos = komaru.m_20183_();
            return !komaru.m_9236_().m_45527_(blockpos) && komaru.m_21692_(blockpos) >= 0.0f;
        }

        public SleepGoal() {
            this.countdown = KomaruEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.sleepTimer = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            KomaruEntity komaru = KomaruEntity.this;
            if (komaru.f_20900_ == 0.0f && komaru.f_20901_ == 0.0f && komaru.f_20902_ == 0.0f) {
                return !komaru.m_5803_() && (this.canSleep() || this.m_8045_()) && !komaru.m_20069_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.sleepTimer > 0;
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return this.hasShelter() && !KomaruEntity.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = KomaruEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.sleepTimer = 0;
            KomaruEntity.this.setSleeping(false);
        }

        public void m_8056_() {
            KomaruEntity komaru = KomaruEntity.this;
            komaru.setSleeping(true);
            komaru.m_21573_().m_26573_();
            komaru.m_21566_().m_6849_(komaru.m_20185_(), komaru.m_20186_(), komaru.m_20189_(), 0.0);
        }

        public void m_8037_() {
            if (this.canSleep()) {
                ++this.sleepTimer;
                if (this.sleepTimer >= SLEEP_DURATION) {
                    KomaruEntity.this.setSleeping(false);
                    this.sleepTimer = 0;
                }
            } else {
                this.sleepTimer = 0;
            }
        }
    }
}

