/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.data;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ConnectedModelProvider<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    String connectionHandle = "same_block";
    int tintIndex = -1;
    int baseTintIndex = -1;
    int emissivity = 0;
    int baseEmissivity = 0;

    public ConnectedModelProvider(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("xycraft_core", "connected_textures"), parent, existingFileHelper);
    }

    public ConnectedModelProvider<T> setEmissivity(int value) {
        this.emissivity = value;
        return this;
    }

    public ConnectedModelProvider<T> setBaseEmissivity(int value) {
        this.baseEmissivity = value;
        return this;
    }

    @Deprecated
    public ConnectedModelProvider<T> setEmissivity(int base, int connectedTexture) {
        this.baseEmissivity = base;
        this.emissivity = connectedTexture;
        return this;
    }

    public ConnectedModelProvider<T> setBaseTintIndex(int value) {
        this.baseTintIndex = value;
        return this;
    }

    public ConnectedModelProvider<T> setTintIndex(int value) {
        this.tintIndex = value;
        return this;
    }

    @Deprecated
    public ConnectedModelProvider<T> setTintIndex(int base, int connectedTexture) {
        this.baseTintIndex = base;
        this.tintIndex = connectedTexture;
        return this;
    }

    public ConnectedModelProvider<T> connectionHandler(String name) {
        this.connectionHandle = name;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        JsonObject jObj = super.toJson(json);
        jObj.addProperty("connection_handler", this.connectionHandle);
        jObj.addProperty("base_tint_index", (Number)this.baseTintIndex);
        jObj.addProperty("tint_index", (Number)this.tintIndex);
        jObj.addProperty("base_emissivity", (Number)this.baseEmissivity);
        jObj.addProperty("emissivity", (Number)this.emissivity);
        return jObj;
    }
}

