/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities.volumes;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.capabilities.volumes.AnchoredVolumeCache;

@AutoRegisterCapability
public class RainShieldVolumeCache
extends AnchoredVolumeCache<VolumeAnchor> {
    public static final Capability<RainShieldVolumeCache> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<RainShieldVolumeCache>(){});

    public RainShieldVolumeCache() {
        super(VolumeAnchor.class);
    }

    public static RainShieldVolumeCache of(Level level) {
        return (RainShieldVolumeCache)level.getCapability(CAPABILITY).orElseThrow(IllegalStateException::new);
    }

    public static void register(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("xycraft_core", "rain_shield_volume_cache"), (ICapabilityProvider)new RainShieldVolumeCache());
    }

    @Override
    public VolumeAnchor createNewAnchor(BlockPos pos) {
        return new VolumeAnchor(pos);
    }

    @Override
    public int getRange() {
        return 16;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.optional.cast());
    }

    public record VolumeAnchor(BlockPos pos) implements AnchoredVolumeCache.IVolumeAnchor<VolumeAnchor>
    {
        @Override
        public BlockPos getAnchorPos() {
            return this.pos();
        }

        @Override
        public Block getAnchorBlock() {
            return (Block)CompatContent.XyCraftMachines.Blocks.WaterBlock.get();
        }
    }
}

