/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks.prototype;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowthType;
import tv.soaryn.xycraft.core.content.blocks.prototype.IGrowableBlock;

public class GrowableImplementations {
    public static IGrowableBlock ThreeTall = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            BlockState checkedBlock;
            int i;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            int currentCount = 1;
            BlockPos.MutableBlockPos topPos = pos.m_122032_();
            BlockPos.MutableBlockPos bottomPos = pos.m_122032_();
            int maxHeight = 3;
            for (i = 1; i < maxHeight && currentCount < maxHeight && (checkedBlock = level.m_8055_((BlockPos)bottomPos.m_122173_(Direction.DOWN))).m_60713_(state.m_60734_()); ++currentCount, ++i) {
            }
            for (i = 1; i < maxHeight && currentCount < maxHeight; ++currentCount, ++i) {
                checkedBlock = level.m_8055_((BlockPos)topPos.m_122173_(Direction.UP));
                if (checkedBlock.m_60713_(state.m_60734_())) {
                    continue;
                }
                if (!checkedBlock.m_60795_()) {
                    return positions;
                }
                topPos.m_122173_(Direction.DOWN);
                break;
            }
            BlockPos finalPos = topPos.m_7949_();
            if (currentCount < maxHeight && (Integer)level.m_8055_(finalPos).m_61143_((Property)SugarCaneBlock.f_57164_) <= 15) {
                positions.add(finalPos);
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.randomTick(level.m_8055_(blockPos), level, (BlockPos)blockPos));
            return positions;
        }

        public boolean randomTick(BlockState state, ServerLevel level, BlockPos pos) {
            BlockPos blockpos = pos.m_7494_();
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                int age = (Integer)state.m_61143_((Property)CactusBlock.f_51131_);
                if (age == 15) {
                    level.m_46597_(blockpos, state.m_60734_().m_49966_());
                    BlockState blockstate = (BlockState)state.m_61124_((Property)CactusBlock.f_51131_, (Comparable)Integer.valueOf(0));
                    level.m_7731_(pos, blockstate, 4);
                    level.m_213960_(blockstate, blockpos, state.m_60734_(), pos, false);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CactusBlock.f_51131_, (Comparable)Integer.valueOf(age + 1)), 4);
                }
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };
    public static IGrowableBlock Crop = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            CropBlock cropBlock;
            Block block;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (level.isAreaLoaded(pos, 1) && level.m_45524_(pos, 0) >= 9 && (block = state.m_60734_()) instanceof CropBlock && !(cropBlock = (CropBlock)block).m_52307_(state)) {
                positions.add(pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.precheckedGrow(level.m_8055_(blockPos), level, (BlockPos)blockPos, randomSource, growthType));
            return positions;
        }

        public boolean precheckedGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource, GrowthType growthType) {
            CropBlock cropBlock = (CropBlock)state.m_60734_();
            int age = cropBlock.m_52305_(state);
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randSource.m_188503_((int)(25.0f / 2.getGrowthSpeed((Block)cropBlock, (BlockGetter)level, pos)) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, cropBlock.m_52289_(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }

        public static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
            float speed = 1.0f;
            BlockPos blockpos = pos.m_7495_();
            for (int r = -1; r <= 1; ++r) {
                for (int c = -1; c <= 1; ++c) {
                    float soilModifier = 0.0f;
                    BlockState blockstate = level.m_8055_(blockpos.m_7918_(r, 0, c));
                    if (blockstate.canSustainPlant(level, blockpos.m_7918_(r, 0, c), Direction.UP, (IPlantable)block)) {
                        soilModifier = 1.0f;
                        if (blockstate.isFertile(level, pos.m_7918_(r, 0, c))) {
                            soilModifier = 3.0f;
                        }
                    }
                    if (r != 0 || c != 0) {
                        soilModifier /= 4.0f;
                    }
                    speed += soilModifier;
                }
            }
            BlockPos northPos = pos.m_122012_();
            BlockPos southPos = pos.m_122019_();
            BlockPos westPos = pos.m_122024_();
            BlockPos eastPos = pos.m_122029_();
            if (level.m_8055_(westPos).m_60713_(block) || level.m_8055_(eastPos).m_60713_(block) && level.m_8055_(northPos).m_60713_(block) || level.m_8055_(southPos).m_60713_(block) || level.m_8055_(westPos.m_122012_()).m_60713_(block) || level.m_8055_(eastPos.m_122012_()).m_60713_(block) || level.m_8055_(eastPos.m_122019_()).m_60713_(block) || level.m_8055_(westPos.m_122019_()).m_60713_(block)) {
                speed /= 2.0f;
            }
            return speed;
        }
    };
    public static IGrowableBlock NetherWart = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) < 3) {
                positions.add(pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.precheckGrow(level.m_8055_(blockPos), level, (BlockPos)blockPos, randomSource, growthType));
            return positions;
        }

        public boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource, GrowthType growthType) {
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randSource.m_188503_(10) == 0 ? 1 : 0) != 0)) {
                BlockState newState = (BlockState)state.m_61122_((Property)NetherWartBlock.f_54967_);
                level.m_7731_(pos, newState, 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)newState);
                return true;
            }
            return false;
        }
    };
    public static IGrowableBlock ChorusFruit = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            this.findFlowersRecusively(state, level, pos, Direction.DOWN, positions);
            positions.removeIf(blockPos -> (Integer)level.m_8055_(blockPos).m_61143_((Property)ChorusFlowerBlock.f_51647_) == 5);
            return positions;
        }

        private void findFlowersRecusively(BlockState focusedState, LevelReader level, BlockPos pos, Direction prevDirection, ArrayList<BlockPos> currentPositions) {
            if (focusedState.m_60713_(Blocks.f_50491_)) {
                currentPositions.add(pos);
                return;
            }
            if (!focusedState.m_60713_(Blocks.f_50490_)) {
                return;
            }
            Boolean up = (Boolean)focusedState.m_61143_((Property)ChorusPlantBlock.f_55152_);
            if (up.booleanValue()) {
                BlockPos nextPos = pos.m_7494_();
                BlockState state = level.m_8055_(nextPos);
                this.findFlowersRecusively(state, level, nextPos, Direction.DOWN, currentPositions);
            } else {
                BlockState state;
                BlockPos nextPos;
                if (((Boolean)focusedState.m_61143_((Property)ChorusPlantBlock.f_55149_)).booleanValue() && prevDirection != Direction.EAST) {
                    nextPos = pos.m_122029_();
                    state = level.m_8055_(nextPos);
                    this.findFlowersRecusively(state, level, nextPos, Direction.WEST, currentPositions);
                }
                if (((Boolean)focusedState.m_61143_((Property)ChorusPlantBlock.f_55151_)).booleanValue() && prevDirection != Direction.WEST) {
                    nextPos = pos.m_122024_();
                    state = level.m_8055_(nextPos);
                    this.findFlowersRecusively(state, level, nextPos, Direction.EAST, currentPositions);
                }
                if (((Boolean)focusedState.m_61143_((Property)ChorusPlantBlock.f_55148_)).booleanValue() && prevDirection != Direction.NORTH) {
                    nextPos = pos.m_122012_();
                    state = level.m_8055_(nextPos);
                    this.findFlowersRecusively(state, level, nextPos, Direction.SOUTH, currentPositions);
                }
                if (((Boolean)focusedState.m_61143_((Property)ChorusPlantBlock.f_55150_)).booleanValue() && prevDirection != Direction.SOUTH) {
                    nextPos = pos.m_122019_();
                    state = level.m_8055_(nextPos);
                    this.findFlowersRecusively(state, level, nextPos, Direction.NORTH, currentPositions);
                }
            }
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.precheckGrow(level.m_8055_(blockPos), level, (BlockPos)blockPos, randomSource));
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource) {
            int age;
            BlockPos blockpos = pos.m_7494_();
            Block block = Blocks.f_50490_;
            if (!(block instanceof ChorusPlantBlock)) {
                return false;
            }
            ChorusPlantBlock plant = (ChorusPlantBlock)block;
            if (level.m_46859_(blockpos) && blockpos.m_123342_() < level.m_151558_() && (age = ((Integer)state.m_61143_((Property)ChorusFlowerBlock.f_51647_)).intValue()) < 5 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                boolean validSoil = false;
                boolean flag1 = false;
                BlockState blockstate = level.m_8055_(pos.m_7495_());
                if (blockstate.m_60713_(Blocks.f_50259_)) {
                    validSoil = true;
                } else if (blockstate.m_60713_((Block)plant)) {
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        BlockState blockstate1 = level.m_8055_(pos.m_6625_(j + 1));
                        if (!blockstate1.m_60713_((Block)plant)) {
                            if (!blockstate1.m_60713_(Blocks.f_50259_)) break;
                            flag1 = true;
                            break;
                        }
                        ++j;
                    }
                    if (j < 2 || j <= randSource.m_188503_(flag1 ? 5 : 4)) {
                        validSoil = true;
                    }
                } else if (blockstate.m_60795_()) {
                    validSoil = true;
                }
                if (validSoil && 4.allNeighborsEmpty((LevelReader)level, blockpos, null) && level.m_46859_(pos.m_6630_(2))) {
                    level.m_7731_(pos, plant.m_51710_((BlockGetter)level, pos), 2);
                    this.placeGrownFlower((Level)level, blockpos, age);
                } else if (age < 4) {
                    int l = randSource.m_188503_(4);
                    if (flag1) {
                        ++l;
                    }
                    boolean placeLivingFlower = false;
                    for (int i1 = 0; i1 < l; ++i1) {
                        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(randSource);
                        BlockPos blockpos1 = pos.m_121945_(direction);
                        if (!level.m_46859_(blockpos1) || !level.m_46859_(blockpos1.m_7495_()) || !4.allNeighborsEmpty((LevelReader)level, blockpos1, direction.m_122424_())) continue;
                        this.placeGrownFlower((Level)level, blockpos1, age + 1);
                        placeLivingFlower = true;
                    }
                    if (placeLivingFlower) {
                        level.m_7731_(pos, plant.m_51710_((BlockGetter)level, pos), 2);
                    } else {
                        this.placeDeadFlower((Level)level, pos);
                    }
                } else {
                    this.placeDeadFlower((Level)level, pos);
                }
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }

        private static boolean allNeighborsEmpty(LevelReader p_51698_, BlockPos p_51699_, @Nullable Direction p_51700_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (direction == p_51700_ || p_51698_.m_46859_(p_51699_.m_121945_(direction))) continue;
                return false;
            }
            return true;
        }

        private void placeGrownFlower(Level p_51662_, BlockPos p_51663_, int age) {
            p_51662_.m_7731_(p_51663_, (BlockState)Blocks.f_50491_.m_49966_().m_61124_((Property)ChorusFlowerBlock.f_51647_, (Comparable)Integer.valueOf(age)), 2);
            p_51662_.m_46796_(1033, p_51663_, 0);
        }

        private void placeDeadFlower(Level p_51659_, BlockPos p_51660_) {
            p_51659_.m_7731_(p_51660_, (BlockState)Blocks.f_50491_.m_49966_().m_61124_((Property)ChorusFlowerBlock.f_51647_, (Comparable)Integer.valueOf(5)), 2);
            p_51659_.m_46796_(1034, p_51660_, 0);
        }
    };
    public static IGrowableBlock GrowingPlantHead = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            Block block = state.m_60734_();
            if (block instanceof GrowingPlantBlock) {
                GrowingPlantBlock growingPlantBlock = (GrowingPlantBlock)block;
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            return this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
        }
    };
    public static IGrowableBlock CocoaBean = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if ((Integer)state.m_61143_((Property)CocoaBlock.f_51736_) < 2) {
                positions.add(pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPosition -> !this.precheckGrow(level.m_8055_(blockPosition), level, (BlockPos)blockPosition, growthType));
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, GrowthType growthType) {
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || level.f_46441_.m_188503_(5) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)CocoaBlock.f_51736_), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };
    public static IGrowableBlock Bamboo = new IGrowableBlock(){

        @Override
        @NotNull
        public ArrayList<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            BlockState stalkState;
            int i;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            Block plantBlock = state.m_60734_();
            int currentCount = 0;
            BlockPos topPos = pos;
            for (i = 0; i < 16 && (stalkState = level.m_8055_(pos.m_6630_(i))).m_60713_(plantBlock); ++i) {
                topPos = pos.m_6630_(i);
                ++currentCount;
            }
            if ((Integer)level.m_8055_(topPos).m_61143_((Property)BambooStalkBlock.f_260694_) != 0) {
                return positions;
            }
            if (currentCount >= 16) {
                return positions;
            }
            for (i = 1; i < 16 && (stalkState = level.m_8055_(pos.m_6625_(i))).m_60713_(plantBlock); ++i) {
                if (++currentCount < 16) continue;
                return positions;
            }
            BlockState topBlock = level.m_8055_(topPos);
            if ((Integer)topBlock.m_61143_((Property)BambooStalkBlock.f_260694_) == 0 && level.m_45524_(topPos.m_7494_(), 0) >= 9) {
                positions.add(topPos);
            }
            return positions;
        }

        @Override
        @NotNull
        public ArrayList<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            ArrayList<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPosition -> !this.precheckGrow(level.m_8055_(blockPosition), level, (BlockPos)blockPosition, randomSource, growthType));
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randomSource.m_188503_(3) == 0 ? 1 : 0) != 0)) {
                int height = 0;
                while (level.m_8055_(pos.m_6625_(height + 1)).m_60713_(Blocks.f_50571_)) {
                    ++height;
                }
                BlockState blockStateBelow = level.m_8055_(pos.m_7495_());
                BlockPos posBelow2 = pos.m_6625_(2);
                BlockState blockStateBelow2 = level.m_8055_(posBelow2);
                BambooLeaves bambooleaves = BambooLeaves.NONE;
                if (++height >= 1) {
                    if (blockStateBelow.m_60713_(Blocks.f_50571_) && blockStateBelow.m_61143_((Property)BambooStalkBlock.f_260716_) != BambooLeaves.NONE) {
                        if (blockStateBelow.m_60713_(Blocks.f_50571_) && blockStateBelow.m_61143_((Property)BambooStalkBlock.f_260716_) != BambooLeaves.NONE) {
                            bambooleaves = BambooLeaves.LARGE;
                            if (blockStateBelow2.m_60713_(Blocks.f_50571_)) {
                                level.m_7731_(pos.m_7495_(), (BlockState)blockStateBelow.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.SMALL), 3);
                                level.m_7731_(posBelow2, (BlockState)blockStateBelow2.m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)BambooLeaves.NONE), 3);
                            }
                        }
                    } else {
                        bambooleaves = BambooLeaves.SMALL;
                    }
                }
                int age = (Integer)state.m_61143_((Property)BambooStalkBlock.f_260603_) != 1 && !blockStateBelow2.m_60713_(Blocks.f_50571_) ? 0 : 1;
                int stage = !(height >= 11 && randomSource.m_188501_() < 0.25f || height == 15) ? 0 : 1;
                level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooStalkBlock.f_260603_, (Comparable)Integer.valueOf(age))).m_61124_((Property)BambooStalkBlock.f_260716_, (Comparable)bambooleaves)).m_61124_((Property)BambooStalkBlock.f_260694_, (Comparable)Integer.valueOf(stage)), 3);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };
}

