/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ShapeUtils;

public abstract class SidePartBlock
extends Block
implements SimpleWaterloggedBlock {
    private final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[6], array -> {
        VoxelShape downShape = this.getDownShapeForBaking();
        Arrays.setAll(array, i -> ShapeUtils.rotate(downShape, Direction.m_122376_((int)i)));
    });

    public SidePartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CoreStateProperties.StateDirection, (Comparable)Direction.DOWN)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        Direction orientation = (Direction)state.m_61143_(CoreStateProperties.StateDirection);
        if (orientation.m_122434_() == Direction.Axis.Y) {
            return state;
        }
        return (BlockState)state.m_61124_(CoreStateProperties.StateDirection, (Comparable)direction.m_55954_(orientation));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        InteractionResult wrenchResult;
        ItemStack stack = player.m_21120_(interactionHand);
        if (IWrenchUse.hasWrenchLikeAction(player, stack, true) && (wrenchResult = IWrenchUse.rotate(state, level, pos, hitResult)) != null) {
            return wrenchResult;
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hitResult);
    }

    public boolean m_6864_(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return false;
    }

    public boolean m_5946_(@NotNull BlockState state, @NotNull Fluid fluid) {
        return false;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CoreStateProperties.StateDirection});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction direction = ctx.m_43719_().m_122424_();
        if (ModifierKeyCapability.of(ctx.m_43723_())) {
            direction = direction.m_122424_();
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(CoreStateProperties.StateDirection, (Comparable)direction)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState other, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, other, level, pos, otherPos);
    }

    public abstract VoxelShape getDownShapeForBaking();

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPES[((Direction)state.m_61143_(CoreStateProperties.StateDirection)).m_122411_()];
    }
}

