/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import com.google.common.base.CaseFormat;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.TorchBlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.data.BlockModelType;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.IRegister;

public class ContentRegistry
implements IRegister {
    private static final CopyOnWriteArrayList<ContentRegistry> RegistryList = new CopyOnWriteArrayList();
    protected static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final String _modId;
    protected int _fieldIndex;
    protected final String[] _fieldNames;
    private final DeferredRegister<Block> _blockMap;
    private final DeferredRegister<Item> _itemMap;
    private final DeferredRegister<BlockEntityType<?>> _entityMap;
    private final DeferredRegister<CreativeModeTab> _tabMap;
    private final DeferredRegister<FluidType> _fluitTypeMap;
    private final DeferredRegister<Fluid> _fluidMap;
    private RegistryObject<CreativeModeTab> _tab = null;
    public final ArrayList<BlockContent> ListOfBlocks = new ArrayList();
    public final ArrayList<ItemContent> ListOfItems = new ArrayList();
    public final ArrayList<IContent<?>> MappedContent = new ArrayList();

    public static Block[] getColorableBlocks() {
        return (Block[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry._blockMap.getEntries().stream().map(Supplier::get).filter(block -> block instanceof IColored)).toArray(Block[]::new);
    }

    public static Item[] getColorableItemBlocks() {
        return (Item[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry._itemMap.getEntries().stream().map(Supplier::get).filter(BlockItem.class::isInstance).map(BlockItem.class::cast).filter(blockItem -> blockItem.m_40614_() instanceof IColored)).toArray(BlockItem[]::new);
    }

    public static Item[] getColorableItems() {
        return (Item[])RegistryList.stream().flatMap(contentRegistry -> contentRegistry._itemMap.getEntries().stream().map(Supplier::get).filter(IColored.class::isInstance).map(Item.class::cast)).toArray(Item[]::new);
    }

    private ContentRegistry(Class<?> c, String modId) {
        this._modId = modId;
        this._blockMap = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modId);
        this._itemMap = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        this._entityMap = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)modId);
        this._fluitTypeMap = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)modId);
        this._fluidMap = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)modId);
        this._tabMap = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modId);
        RegistryList.add(this);
        this._fieldNames = (String[])Arrays.stream(c.getFields()).filter(field -> {
            Class<EnumMap> fieldType = field.getType();
            return IContent.class.isAssignableFrom(fieldType) || BlockContent.class.isAssignableFrom(fieldType) || ItemContent.class.isAssignableFrom(fieldType) || fieldType.isAssignableFrom(EnumMap.class) && (((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName().equals(BlockContent.class.getTypeName()) || ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName().equals(ItemContent.class.getTypeName()));
        }).map(field -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName())).toArray(String[]::new);
    }

    public static ContentRegistry builder(String modId) {
        return new ContentRegistry(STACK_WALKER.getCallerClass(), modId);
    }

    public RegistryObject<CreativeModeTab> tab(String title, Function<CreativeModeTab.Builder, CreativeModeTab> tabFactory) {
        this._tab = this._tabMap.register("tab_" + title, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.%s".formatted(this._modId))).withTabFactory(tabFactory).m_257652_());
        return this._tab;
    }

    public ContentRegistry withTab(RegistryObject<CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    public BlockContent block(Supplier<Block> block, Function<Block, Item> item) {
        String name = this._fieldNames[this._fieldIndex++];
        RegistryObject RegistryBlock = this._blockMap.register(name, block);
        RegistryObject RegistryItem = this._itemMap.register(name, () -> (Item)item.apply((Block)RegistryBlock.get()));
        BlockContent content = new BlockContent((RegistryObject<Block>)RegistryBlock, (RegistryObject<Item>)RegistryItem);
        this.ListOfBlocks.add(content);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public BlockContent block(Supplier<Block> block, Function<Block, Item> item, Function<Block, BlockEntityType<?>> entityFunction) {
        String name = this._fieldNames[this._fieldIndex++];
        RegistryObject registryBlock = this._blockMap.register(name, block);
        RegistryObject registryItem = this._itemMap.register(name, () -> (Item)item.apply((Block)registryBlock.get()));
        RegistryObject registryEntity = this._entityMap.register(name, () -> (BlockEntityType)entityFunction.apply((Block)registryBlock.get()));
        BlockContent content = new BlockContent((RegistryObject<Block>)registryBlock, (RegistryObject<Item>)registryItem, registryEntity);
        this.ListOfBlocks.add(content);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public EnumMap<CustomColors, BlockContent> colorBlock(String localizedName, BlockModelType type) {
        return this.colorBlock(CustomColors.class, localizedName, type, (T customColor) -> () -> new ColoredBlock((ColorSource)customColor, BlockBehaviour.Properties.m_284310_().m_60999_().m_155954_(Blocks.f_50069_.m_155943_())));
    }

    public EnumMap<CustomColors, BlockContent> colorBlock(String localizedName, BlockModelType type, Supplier<BlockBehaviour.Properties> properties) {
        return this.colorBlock(CustomColors.class, localizedName, type, (T customColor) -> () -> ContentRegistry.lambda$colorBlock$17(customColor, (Supplier)properties));
    }

    public <T extends Enum<T>> EnumMap<T, BlockContent> colorBlock(Class<T> c, Function<T, Supplier<Block>> blockFunction, BiConsumer<T, BlockContent> contentConsumer) {
        return this.colorBlock(c, blockFunction, contentConsumer, (T t, BlockContent blockContent) -> blockContent.setTab((RegistryObject)this._tab));
    }

    public <T extends Enum<T>> EnumMap<T, BlockContent> colorBlock(Class<T> c, Function<T, Supplier<Block>> blockFunction, BiConsumer<T, BlockContent> contentConsumer, BiConsumer<T, BlockContent> handleTab) {
        String name = this._fieldNames[this._fieldIndex++];
        return (EnumMap)Util.m_137469_(new EnumMap(c), map -> {
            for (Enum color : (Enum[])c.getEnumConstants()) {
                RegistryObject registryBlock = this._blockMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)blockFunction.apply(color));
                RegistryObject registryItem = this._itemMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), () -> new XyBlockItem((Block)registryBlock.get(), new Item.Properties()));
                BlockContent content = new BlockContent((RegistryObject<Block>)registryBlock, (RegistryObject<Item>)registryItem);
                if (color instanceof DyeColor) {
                    DyeColor dye = (DyeColor)color;
                    content.withColor(new ColorSource.Dye(dye).getColor());
                } else if (color instanceof CustomColors) {
                    CustomColors custom = (CustomColors)color;
                    content.withColor(custom.getColor());
                }
                content.withModelPath(name);
                contentConsumer.accept(color, content);
                this.ListOfBlocks.add(content);
                this.MappedContent.add(content);
                handleTab.accept(color, content);
                map.put(color, content);
            }
        });
    }

    public <T extends Enum<T>> EnumMap<T, BlockContent> colorBlock(Class<T> c, Function<T, Supplier<Block>> blockFunction, BiFunction<T, RegistryObject<Block>, Supplier<Item>> itemFunction, BiConsumer<Enum<T>, BlockContent> contentConsumer) {
        String name = this._fieldNames[this._fieldIndex++];
        return (EnumMap)Util.m_137469_(new EnumMap(c), map -> {
            for (Enum color : (Enum[])c.getEnumConstants()) {
                RegistryObject registryBlock = this._blockMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)blockFunction.apply(color));
                RegistryObject registryItem = this._itemMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)itemFunction.apply(color, registryBlock));
                BlockContent content = new BlockContent((RegistryObject<Block>)registryBlock, (RegistryObject<Item>)registryItem);
                content.withModelPath(name);
                if (color instanceof DyeColor) {
                    DyeColor dye = (DyeColor)color;
                    content.withColor(new ColorSource.Dye(dye).getColor());
                } else if (color instanceof CustomColors) {
                    CustomColors custom = (CustomColors)color;
                    content.withColor(custom.getColor());
                }
                contentConsumer.accept(color, content);
                this.ListOfBlocks.add(content);
                this.MappedContent.add(content);
                map.put(color, content);
            }
        });
    }

    public <T extends Enum<T>> EnumMap<T, BlockContent> colorBlock(Class<T> c, String localizedName, BlockModelType type, Function<T, Supplier<Block>> blockFunction) {
        String name = this._fieldNames[this._fieldIndex++];
        return (EnumMap)Util.m_137469_(new EnumMap(c), map -> {
            for (Enum color : (Enum[])c.getEnumConstants()) {
                RegistryObject registryBlock = this._blockMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)blockFunction.apply(color));
                RegistryObject registryItem = this._itemMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), () -> new XyBlockItem((Block)registryBlock.get(), new Item.Properties()));
                BlockContent content = new BlockContent((RegistryObject<Block>)registryBlock, (RegistryObject<Item>)registryItem);
                content.withModelPath(name);
                content.withModelType(type);
                content.withName(localizedName.formatted(color.name()));
                if (color instanceof DyeColor) {
                    DyeColor dye = (DyeColor)color;
                    content.withColor(new ColorSource.Dye(dye).getColor());
                } else if (color instanceof CustomColors) {
                    CustomColors custom = (CustomColors)color;
                    content.withColor(custom.getColor());
                }
                this.ListOfBlocks.add(content);
                this.MappedContent.add(content);
                content.setTab((RegistryObject)this._tab);
                map.put(color, content);
            }
        });
    }

    public <T extends Enum<T>> EnumMap<T, BlockContent> colorBlock(Class<T> c, String localizedName, BlockModelType type, Function<T, Supplier<Block>> blockFunction, BiFunction<T, RegistryObject<Block>, Supplier<Item>> itemFunction) {
        String name = this._fieldNames[this._fieldIndex++];
        return (EnumMap)Util.m_137469_(new EnumMap(c), map -> {
            for (Enum color : (Enum[])c.getEnumConstants()) {
                RegistryObject registryBlock = this._blockMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)blockFunction.apply(color));
                RegistryObject registryItem = this._itemMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)itemFunction.apply(color, registryBlock));
                BlockContent content = new BlockContent((RegistryObject<Block>)registryBlock, (RegistryObject<Item>)registryItem);
                content.withModelPath(name);
                content.withModelType(type);
                content.withName(localizedName.formatted(color.name()));
                if (color instanceof DyeColor) {
                    DyeColor dye = (DyeColor)color;
                    content.withColor(new ColorSource.Dye(dye).getColor());
                } else if (color instanceof CustomColors) {
                    CustomColors custom = (CustomColors)color;
                    content.withColor(custom.getColor());
                }
                this.ListOfBlocks.add(content);
                this.MappedContent.add(content);
                map.put(color, content);
            }
        });
    }

    public BlockContent block() {
        return this.block(XyBlock::new, blockR -> new XyBlockItem((Block)blockR, new Item.Properties()));
    }

    public BlockContent block(Supplier<Block> blockSupplier) {
        return this.block(blockSupplier, blockR -> new XyBlockItem((Block)blockR, new Item.Properties()));
    }

    public TorchBlockContent torch(Supplier<Block> block, Function<RegistryObject<Block>, Supplier<Block>> wall, BiFunction<RegistryObject<Block>, RegistryObject<Block>, Supplier<Item>> torchItemSupplier) {
        String name = this._fieldNames[this._fieldIndex++];
        RegistryObject RegistryBlock = this._blockMap.register(name, block);
        RegistryObject RegistryWall = this._blockMap.register(name + "_wall", wall.apply((RegistryObject<Block>)RegistryBlock));
        RegistryObject RegistryItem = this._itemMap.register(name, torchItemSupplier.apply((RegistryObject<Block>)RegistryBlock, (RegistryObject<Block>)RegistryWall));
        TorchBlockContent content = new TorchBlockContent((RegistryObject<Block>)RegistryBlock, (RegistryObject<Block>)RegistryWall, (RegistryObject<Item>)RegistryItem);
        this.ListOfBlocks.add(content);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public <T extends Enum<T>> EnumMap<T, ItemContent> item(Class<T> c, String localizedName, Function<T, Supplier<Item>> itemSupplier) {
        String name = this._fieldNames[this._fieldIndex++];
        return (EnumMap)Util.m_137469_(new EnumMap(c), map -> {
            for (Enum color : (Enum[])c.getEnumConstants()) {
                ItemContent content = new ItemContent((RegistryObject<Item>)this._itemMap.register(name + "_" + ((StringRepresentable)color).m_7912_(), (Supplier)itemSupplier.apply(color)));
                this.ListOfItems.add(content);
                this.MappedContent.add(content);
                content.withName(localizedName.formatted(color.name()));
                map.put(color, content);
                content.setTab((RegistryObject)this._tab);
            }
        });
    }

    public ItemContent item() {
        return this.item(() -> new XyItem(new Item.Properties()));
    }

    public ItemContent item(Supplier<Item> itemSupplier) {
        String name = this._fieldNames[this._fieldIndex++];
        ItemContent content = new ItemContent((RegistryObject<Item>)this._itemMap.register(name, itemSupplier));
        this.ListOfItems.add(content);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public ItemContent item(Function<String, Supplier<Item>> itemSupplier) {
        String name = this._fieldNames[this._fieldIndex++];
        ItemContent content = new ItemContent((RegistryObject<Item>)this._itemMap.register(name, itemSupplier.apply(name)));
        this.ListOfItems.add(content);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public FluidContent fluid() {
        return this.fluid(XyFluidType::supplier, ContentRegistry::basic, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new);
    }

    public FluidContent fluid(Function<String, XyFluidType> type) {
        return this.fluid(type, ContentRegistry::basic, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new);
    }

    public FluidContent fluid(Function<String, XyFluidType> type, @Nullable Consumer<ForgeFlowingFluid.Properties> fluidProperties, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> source, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowing) {
        String name = this._fieldNames[this._fieldIndex++];
        FluidContent content = new FluidContent(name, this._fluidMap, this._fluitTypeMap, () -> ((XyFluidType)((Object)((Object)type.apply("xycraft_machines.fluid." + name)))).setStillResource(new ResourceLocation(this._modId, "block/fluids/" + name)).setFlowResource(new ResourceLocation(this._modId, "block/fluids/" + name + "_flowing")), source, flowing, fluidProperties);
        this.MappedContent.add(content);
        content.setTab((RegistryObject)this._tab);
        return content;
    }

    public static void basic(ForgeFlowingFluid.Properties properties) {
    }

    @Override
    public void register(IEventBus bus) {
        this._blockMap.register(bus);
        this._itemMap.register(bus);
        this._entityMap.register(bus);
        this._fluitTypeMap.register(bus);
        this._fluidMap.register(bus);
        this._tabMap.register(bus);
    }

    private static /* synthetic */ Block lambda$colorBlock$17(CustomColors customColor, Supplier properties) {
        return new ColoredBlock(customColor, (BlockBehaviour.Properties)properties.get());
    }

    public static enum TabHandling {
        Default,
        Hide,
        OnlyRoot;

    }
}

